/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus;

/**
 * AbstractDOMBusComponent
 *
 * @since   Mar. 29, 2000
 * @version Aug.  7, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractDOMBusComponent implements IDOMBusComponent {
    protected String[] args_;
    protected DOMBus bus_;
    protected IDOMBusContext context_;

    public void setup(String[] args) {
	args_ = args;
    }

    public void setup(IDOMBusContext context) {
	context_ = context;
    }

    public void setup(DOMBus bus) {
	bus_ = bus;
    }

    public boolean init() {
	return (false);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public Object fire(DOMBusSignal signal) {
	return (null);
    }

    protected void _sendSignal(String label) {
	_sendSignal(new DOMBusSignal(label));
    }

    protected void _sendSignal(String label, Object content) {
	_sendSignal(new DOMBusSignal(label, content));
    }

    protected void _sendSignal(DOMBusSignal signal) {
	bus_.stimulus(signal);
    }

    protected void _info(String message) {
	_sendSignal(new DOMBusSignal("info", message));
    }

    protected void _verbose(String message) {
	_sendSignal(new DOMBusSignal("verbose", message));
    }

    protected void _warning(String message) {
	_sendSignal(new DOMBusSignal("warning", message));
    }

    protected void _error(String message) {
	_sendSignal(new DOMBusSignal("error", message));
    }

    protected void _debug(String message) {
	_sendSignal(new DOMBusSignal("debug", message));
    }
}
