/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus;

import java.util.*;
import jp.gr.java_conf.jaba2.ctype.*;

/**
 * DOMBusSignal
 *
 * @since   Mar. 28, 2000
 * @version Aug. 24, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusSignal {
    private String from_;
    private String to_;
    private String label_;
    private Map properties_ = new HashMap();
    private ICType type_;
    private Object content_;
    private int nParticipants_ = 0;

    public DOMBusSignal(String label) {
	label_ = label;
    }

    public DOMBusSignal(String label, Object content) {
	label_ = label;
	if (content != null) {
	    type_ = new ClassCType(content);
	    content_ = content;
	}
    }

    public DOMBusSignal(String label, Object content, DOMBusSignal signal) {
	label_ = label;
	if (content != null) {
	    type_ = new ClassCType(content);
	    content_ = content;
	}
	properties_.putAll(signal.properties_);
    }

    // Object
    public String toString() {
	return ("Signal [label:" + label_ + ";content:" + content_ + "]");
    }

    public final String getLabel() {
	return (label_);
    }

    public final ICType getType() {
	return (type_);
    }

    public final Object getContent() {
	return (content_);
    }

    public final String getFrom() {
	return (from_);
    }

    public final String getTo() {
	return (to_);
    }

    public final void setProperty(String key, Object value) {
	properties_.put(key, value);
    }

    public final Object getProperty(String key) {
	return (properties_.get(key));
    }

    public final void setNParticipants(int n) {
	nParticipants_ = n;
    }

    public synchronized void consume() {
	if (nParticipants_ == 0) {
	    throw (new InternalError());
	}
	nParticipants_--;
	if (nParticipants_ == 0) {
	    notifyAll();
	}
    }

    public synchronized void syncParticipants() {
	while (nParticipants_ != 0) {
	    try {
		wait();
	    } catch (InterruptedException e) {
	    }
	}
    }
}
