package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CEventGuardPredicate</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="guardPredicate" role="event" type="emptyString"/>
 * 
 * <tag name="event">
 *   <attribute name="label" required="true" type="Name"/>
 *   <attribute name="instanceof" type="Name"/>
 *   <attribute name="from" type="Name"/>
 *   <attribute name="to" type="Name"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="guardPredicate" role="event" type="emptyString"/&gt;
 * &lt;tag name="event"&gt;
 *   &lt;attribute name="label" required="true" type="Name"/&gt;
 *   &lt;attribute name="instanceof" type="Name"/&gt;
 *   &lt;attribute name="from" type="Name"/&gt;
 *   &lt;attribute name="to" type="Name"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:15 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CEventGuardPredicate implements java.io.Serializable, ICAndGuardPredicateContent, ICOrGuardPredicateContent, ICGuardContent {
    private String label;
    private String instanceofValue;
    private String from;
    private String to;

    /**
     * Creates a <code>CEventGuardPredicate</code>.
     *
     */
    public CEventGuardPredicate() {
    }

    /**
     * Creates a <code>CEventGuardPredicate</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CEventGuardPredicate(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CEventGuardPredicate</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CEventGuardPredicate(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CEventGuardPredicate</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CEventGuardPredicate(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CEventGuardPredicate</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CEventGuardPredicate</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CEventGuardPredicate</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        label = URelaxer.getAttributePropertyAsString(element, "label");
        instanceofValue = URelaxer.getAttributePropertyAsString(element, "instanceof");
        from = URelaxer.getAttributePropertyAsString(element, "from");
        to = URelaxer.getAttributePropertyAsString(element, "to");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("event");
        int size;
        URelaxer.setAttributePropertyByString(element, "label", label);
        if (instanceofValue != null) {
            URelaxer.setAttributePropertyByString(element, "instanceof", instanceofValue);
        }
        if (from != null) {
            URelaxer.setAttributePropertyByString(element, "from", from);
        }
        if (to != null) {
            URelaxer.setAttributePropertyByString(element, "to", to);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>label</b>.
     *
     * @return String
     */
    public final String getLabel() {
        return (label);
    }

    /**
     * Sets the String property <b>label</b>.
     *
     * @param label
     */
    public final void setLabel(String label) {
        this.label = label;
    }

    /**
     * Gets the String property <b>instanceof</b>.
     *
     * @return String
     */
    public final String getInstanceof() {
        return (instanceofValue);
    }

    /**
     * Sets the String property <b>instanceof</b>.
     *
     * @param instanceofValue
     */
    public final void setInstanceof(String instanceofValue) {
        this.instanceofValue = instanceofValue;
    }

    /**
     * Gets the String property <b>from</b>.
     *
     * @return String
     */
    public final String getFrom() {
        return (from);
    }

    /**
     * Sets the String property <b>from</b>.
     *
     * @param from
     */
    public final void setFrom(String from) {
        this.from = from;
    }

    /**
     * Gets the String property <b>to</b>.
     *
     * @return String
     */
    public final String getTo() {
        return (to);
    }

    /**
     * Sets the String property <b>to</b>.
     *
     * @param to
     */
    public final void setTo(String to) {
        this.to = to;
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CEventGuardPredicate</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"event".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CEventGuardPredicate</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CEventGuardPredicate</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
