/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.j2fw.generator;

import java.util.*;
import java.io.*;
import jp.gr.java_conf.jaba2.util.*;
import jp.gr.java_conf.jaba2.j2fw.generator.IPackager;
// import jp.gr.java_conf.jaba2.j2fw.generator.packager.*;

/**
 * PackagerFactory
 *
 * @since   May. 10, 1999
 * @version Jul. 27, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public final class PackagerFactory extends ExtensibleFactory {
    protected PropertyList packagers_;
    protected String default_;
    protected Map packgerByName_ = new HashMap();

    public PackagerFactory(String string) {
	packagers_ = new PropertyList(string);
	default_ = (String)packagers_.get("_default_");
	try {
	    _setup(getClass().getResource(
		"/jp/gr/java_conf/jaba2/j2fw/generator/Packager.xml"
	    ));
	} catch (IOException e) {
	    throw (new InternalError());
	}
    }

    public IPackager getPackagerByGenerator(String id) {
	String name = (String)packagers_.get(id);
	if (name != null) {
	    return (getPackagerByName(name));
	} else {
	    return (getPackagerByName(default_));
	}
    }

    public IPackager getPackagerByName(String name) {
	return ((IPackager)getTargetObject(name));
    }
/*
    public IPackager getPackagerByName(String name) {
	if ("file".equals(name)) {
	    return (new FilePackager());
	} else if ("dir".equals(name)) {
	    return (new DirectoryPackager());
	} else if ("jar".equals(name)) {
	    return (new SmartDocJarPackager());
	} else if ("dirjar".equals(name)) {
	    return (new DirectoryJarPackager());
	} else if ("stdout".equals(name)) {
	    return (new StdoutPackager());
	} else {
	    throw (new IllegalArgumentException(name));
	}
    }
*/
}
