/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.j2fw.generator.packager;

import java.io.*;
import java.net.URL;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.j2fw.generator.*;

/**
 * FilePackager
 *
 * @since   May. 10, 1999
 * @version Aug. 30, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class FilePackager implements IPackager {
    public void pack(
	GeneratorArtifact[] artifacts,
	GeneratorResult result,
	String id,
	Object arg,
	File dest
    ) throws IOException {
	if (dest == null) {
	    String baseURI = (String)result.getProperty("baseURI");
	    if (baseURI != null) {
		URL url = null;
		try {
		    url = UURL.getURLFromFileOrURLName(baseURI);
		    dest = new File(url.getFile());
		} catch (IllegalArgumentException e) {
		}
	    }
	}
	for (int i = 0;i < artifacts.length;i++) {
	    GeneratorArtifact artifact = artifacts[i];
	    artifact.makeFile(dest);
/*
	    if ("link".equals(artifact.encoding)) {
		File to = new File(dest, artifact.name);
		File from = new File(artifact.content);
//		if (!to.equals(from)) { XXX does not work at lease on Win95
		if (to.getAbsolutePath().equals(from.getAbsolutePath())) {
		    UFile.copyFile(from, to);
		}
	    } else {
		UFile.createFile(
		    new File(dest, artifact.name),
		    artifact.content,
		    artifact.encoding
		);
	    }
*/
	}
    }
}
