/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.lang;

/**
 * LJVariable
 *
 * @since   Jan. 17, 2000
 * @version May. 21, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public abstract class LJVariable implements IAccessMode {
    private String name_;
    private LJType type_;
    private int access_;
    private boolean isStatic_;
    private String defaultValue_;

    public LJVariable(String name, LJType type) {
	this(name, type, ACCESS_PUBLIC);
    }

    public LJVariable(String name, LJType type, int access) {
	name_ = name;
	type_ = type;
	access_ = access;
    }

    public final String getName() {
	return (name_);
    }

    public final LJType getType() {
	return (type_);
    }

    public final int getAccessMode() {
	return (access_);
    }

    public final String getDefaultValue() {
	return (defaultValue_);
    }

    public final void setStatic(boolean isStatic) {
	isStatic_ = isStatic;
    }

    public final boolean isStatic() {
	return (isStatic_);
    }

    public final void setDefaultValue(String defaultValue) {
	defaultValue_ = defaultValue;
    }
}
