/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.file;

import java.util.*;
import java.io.*;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.vfs.*;
import jp.gr.java_conf.jaba2.vfs.filter.AnyFilter;

/**
 * FileContainer
 *
 * @since   Jan. 15, 2000
 * @version Jan. 27, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class FileRoot extends AbstractVFSRoot {
    protected File dir_;

    public FileRoot(File dir) {
	dir_ = dir;
    }

    public void shallowSetup(IFilter filter) {
	_shallowSetup(filter);
    }

    public void deepSetup(IFilter filter) {
	File[] files = UFile.listFilesAsFile(dir_);
	if (files != null) {
	    _init(files);
	}
	_deepSetup(filter);
    }

    private void _init(File[] files) {
	if (files == null) {
	    throw (new InternalError());
	}
	for (int i = 0;i < files.length;i++) {
	    File child = files[i];
	    if (child.isDirectory()) {
		FileContainer container = new FileContainer(child);
		addContainer(container);
		_init(container, child);
	    } else if (child.isFile()) {
		addObject(new FileObject(child));
	    } else {
		// XXX : symbolic link?
		throw (new UnsupportedOperationException());
	    }
	}
    }

    private void _init(FileContainer parent, File dir) {
	File[] files = UFile.listFilesAsFile(dir);
	if (files == null) {
	    throw (new InternalError());
	}
	for (int i = 0;i < files.length;i++) {
	    File child = files[i];
	    if (child.isDirectory()) {
		FileContainer container = new FileContainer(child);
		parent.addContainer(container);
		_init(container, child);
	    } else if (child.isFile()) {
		parent.addObject(new FileObject(child));
	    } else {
		// XXX : symbolic link?
		throw (new UnsupportedOperationException());
	    }
	}
    }
}
