/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.diff;

import java.net.URL;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * XMLDiff
 *
 * @since   May.  9, 2000
 * @version Aug. 21, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XMLDiff {
    private Node oldRoot_;
    private Node newRoot_;
    private Node current_;

    public Node makeDiffNode(Node oldNode, Node newNode) {
	oldRoot_ = oldNode;
	newRoot_ = newNode;
	_makeDiff(oldRoot_, newRoot_);
	return (newRoot_);
    }

    private void _makeDiff(Node oldNode, Node newNode) {
	if (_isDifferentNode(oldNode, newNode)) {
	    _setStatus(newNode, "nodeDiff", "modified");
	} else {
	    NamedNodeMap oldAttrs = oldNode.getAttributes();
	    NamedNodeMap newAttrs = newNode.getAttributes();
	    String attrsStatus = _getAttrsStatus(oldAttrs, newAttrs);
	    if (attrsStatus != null) {
		_setStatus(newNode, "attrDiff", "modified");
	    }
	    NodeList oldChildren = oldNode.getChildNodes();
	    NodeList newChildren = newNode.getChildNodes();
	    int oldLength = oldChildren.getLength();
	    int newLength = newChildren.getLength();
	    if (oldLength != newLength) {
		_setStatus(newNode, "nodeDiff", "modified");
	    } else {
		for (int i = 0;i < oldLength;i++) {
		    _makeDiff(oldChildren.item(i), newChildren.item(i));
		}
	    }
	}
    }

    private void _setStatus(Node node, String attrName, String value) {
	for (;;) {
	    if (node instanceof Element) {
		Element element = (Element)node;
		element.setAttribute(attrName, value);
		return;
	    }
	    node = node.getParentNode();
	    if (node == null) {
		return;
	    }
	}
    }

    private String _getAttrsStatus(
	NamedNodeMap oldAttrs,
	NamedNodeMap newAttrs
    ) {
	int oldLength = oldAttrs.getLength();
	int newLength = newAttrs.getLength();
	if (true) {		// policy
	    if (oldLength != newLength) {
		return ("modified");
	    }
	    for (int i = 0;i < oldLength;i++) {
		Attr oldAttr = (Attr)oldAttrs.item(i);
		String oldName = oldAttr.getName();
		String oldValue = oldAttr.getValue();
		Attr newAttr = (Attr)newAttrs.getNamedItem(oldName);
		if (newAttr == null) {
		    return ("modified");
		}
		if (!oldValue.equals(newAttr.getValue())) {
		    return ("modified");
		}
	    }
	    return (null);
	} else {
	    throw (new InternalError());
	}
    }

    private String _getChildrenStatus(Node oldNode, Node newNode) {
	NodeList oldChildren = oldNode.getChildNodes();
	NodeList newChildren = newNode.getChildNodes();
	int oldLength = oldChildren.getLength();
	int newLength = newChildren.getLength();
	if (true) {		// policy
	    if (oldLength != newLength) {
		return ("modified");
	    }
	    for (int i = 0;i < oldLength;i++) {
		if (_isDifferentNode(
		    oldChildren.item(i),
		    newChildren.item(i))) {

		    return ("modified");
		}
	    }
	    return (null);
	} else {
	    throw (new InternalError());
	}
    }

    private boolean _isDifferentNode(Node oldNode, Node newNode) {
	if (oldNode.getNodeType() != newNode.getNodeType()) {
	    return (true);
	}
	String oldNodeName = oldNode.getNodeName();
	String oldNodeValue = oldNode.getNodeValue();
	String newNodeName = newNode.getNodeName();
	String newNodeValue = newNode.getNodeValue();
	if (oldNodeName == null) {
	    if (newNodeName != null) {
		return (true);
	    }
	} else {
	    if (!oldNodeName.equals(newNodeName)) {
		return (true);
	    }
	}
	if (oldNodeValue == null) {
	    if (newNodeValue != null) {
		return (true);
	    }
	} else {
	    if (!oldNodeValue.equals(newNodeValue)) {
		return (true);
	    }
	}
	return (false);
    }

    // test driver
    public static void main(String[] args) throws Exception {
	IProcessor processor = ProcessorFactory.getProcessor();
	URL oldURL = UURL.getURLFromFileOrURLName(args[0]);
	URL newURL = UURL.getURLFromFileOrURLName(args[1]);
	Document oldDoc = processor.parseDocument(oldURL);
	Document newDoc = processor.parseDocument(newURL);
	XMLDiff diff = new XMLDiff();
	Node result = diff.makeDiffNode(oldDoc, newDoc);
	System.out.println(UXML.doc2String4Print((Document)result));
    }
}
