/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.*;

/**
 * CInterleave
 *
 * @since   May. 10, 2002
 * @version Jul. 12, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class CInterleave extends CNode implements ICParticle, ICContentModel {
    protected List particles_ = new ArrayList(); // List<ICParticle>
    private COccurs occurs_;

    public CInterleave() {
	occurs_ = new COccurs("");
    }

    public CInterleave(String occurs) {
	occurs_ = new COccurs(occurs);
    }

    public CInterleave(COccurs occurs) {
	occurs_ = occurs;
    }

    public final void addParticle(ICParticle particle) {
	particles_.add(particle);
    }

    public final ICParticle[] getParticles() {
	ICParticle[] particles = new ICParticle[particles_.size()];
	return ((ICParticle[])particles_.toArray(particles));
    }

    public final COccurs getOccurs() {
	return (occurs_);
    }
}
