/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.*;

/**
 * CSequence
 *
 * @since   Nov.  3, 2002
 * @version Nov.  3, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class CList extends CNode implements ICParticle, ICContentModel {
    private List particles_ = new ArrayList();
    private COccurs occurs_;
    private String expr_;

    public CList() {
	occurs_ = new COccurs("");
    }

    public CList(String occurs) {
	occurs_ = new COccurs(occurs);
    }

    public final void addParticle(ICParticle particle) {
	particles_.add(particle);
    }

    public final ICParticle[] getParticles() {
	ICParticle[] particles = new ICParticle[particles_.size()];
	return ((ICParticle[])particles_.toArray(particles));
    }

    public final int getParticleCount() {
	return (particles_.size());
    }

    public final COccurs getOccurs() {
	return (occurs_);
    }

    public final void setExpr(String expr) {
	expr_ = expr;
    }

    public final String getExpr() {
	return (expr_);
    }
}
