/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EContentNode
 *
 * @since   Jan. 17, 2000
 * @version Nov.  9, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class EContentNode extends ERuleNode {
    // List<Element>
    private TextPattern textPattern_ = null;

    public EContentNode(String label) {
	super("content", label);
	setAttribute("id", "content" + getId());
    }

    public void setTextPattern(TextPattern pattern) {
	if (size() > 0) {
	    throw (new InternalError(pattern.getPattern().toString()));
	}
	textPattern_ = pattern;
    }

    public TextPattern getTextPattern() {
	return (textPattern_);
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
