/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2003  ASAMI, Tomoharu (asami@AsamiOfice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.datatype.IXMLDatatype;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EElementSlot
 *
 * @since   Jan.  3, 2000
 * @version May. 22, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOfice.com)
 */
public class EElementSlot extends ESlotNode implements IEOccurs {
    private String elementName_;
    private int occurs_;
    private EElementNode eNode_;

    public EElementSlot(String tagName, IXMLDatatype type) {
	this(tagName, type, OCCURS_ONE);
    }

    public EElementSlot(String tagName, IXMLDatatype type, int occurs) {
	super("elementSlot", type);
	elementName_ = tagName;
	occurs_ = occurs;
	setAttribute("tag", tagName); // info
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public EElementSlot(EElementSlot eSlot) {
	this(eSlot.getElementName(), eSlot.getDatatype(), eSlot.getOccurs());
	eNode_ = eSlot.eNode_;
	setBase(eSlot.getBase());
    }

    public final String getElementName() {
	return (elementName_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setElementNode(EElementNode eNode) {
	eNode_ = eNode;
    }

    public final EElementNode getElementNode() {
	return (eNode_);
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
