/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EExternalRefNode
 *
 * @since   Nov. 17, 2000
 * @version Dec.  1, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class EExternalRefNode extends ENode implements IEOccurs {
    private String namespace_;
    private String label_;
    private int occurs_;
    private EElementNode eNode_;

    public EExternalRefNode(EExternalRefNode ref) {
	this(ref.getNamespace(), ref.getLabel(), ref.getOccurs());
	eNode_ = ref.eNode_;
    }

    public EExternalRefNode(String namespace, String label, int occurs) {
	super("externalRef");
	namespace_ = namespace;
	label_ = label;
	occurs_ = occurs;
	setAttribute("namespace", namespace);
	setAttribute("label", label);
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public EExternalRefNode(String namespace, EElementNode eNode, int occurs) {
	super("externalRef");
	namespace_ = namespace;
	label_ = eNode.getLabel();
	occurs_ = occurs;
	eNode_ = eNode;
	setAttribute("namespace", namespace);
	setAttribute("label", label_);
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public final String getNamespace() {
	return (namespace_);
    }

    public final String getLabel() {
	return (label_);
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public final void setElementNode(EElementNode eNode) {
	eNode_ = eNode;
    }

    public final EElementNode getElementNode() {
	return (eNode_);
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }

    public synchronized void lockWrite() throws InterruptedException {
	super.lockWrite();
	eNode_.lockWrite();
    }

    public synchronized void unlockWrite() throws InterruptedException {
	eNode_.unlockWrite();
	super.unlockWrite();
    }

    public synchronized boolean isLockWrite() {
	return (eNode_.isLockWrite());
    }

    public synchronized void lockRead() throws InterruptedException {
	super.lockRead();
	eNode_.lockRead();
    }

    public synchronized void unlockRead() throws InterruptedException {
	eNode_.unlockRead();
	super.unlockRead();
    }

    public synchronized boolean isLockRead() {
	return (eNode_.isLockRead());
    }
}
