/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.Element;
import jp.gr.java_conf.jaba2.xml.pdom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * ERuleNode
 *
 * @since   Jan.  2, 2000
 * @version Dec. 16, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class ERuleNode extends ENode {
    private int id_;
    private String label_;
    private String baseName_;
    private String uniqueName_;
    private Element attrBase_;
    private Set cyclicRefs_ = null;

    protected ERuleNode(String name, String label) {
	super(name);
	label_ = label;
	id_ = nextId__++;
	setAttribute("label", label);
    }

     public final int getId() {
	return (id_);
    }

    public final String getLabel() {
	return (label_);
    }

    public final void setLabel(String label) {
	label_ = label;
	setAttribute("label", label);
    }

    public final void setBaseName(String name) {
	baseName_ = name;
    }

    public final void setUniqueName(String name) {
	uniqueName_ = name;
	setAttribute("uniqueName", uniqueName_);
    }

    public final String getUniqueName() {
	if (uniqueName_ != null) {
	    return (uniqueName_);
	}
	if (baseName_ != null) {
	    return (baseName_);
	}
	return (label_);
    }

    public final void setAttrBase(Element attrBase) {
	attrBase_ = attrBase;
    }

    public final Element getAttrBase() {
	return (attrBase_);
    }

    public final void setCyclicRefs(Set refs) {
	cyclicRefs_ = refs;
    }

    public final boolean isCyclic(ERuleNode target) {
	if (cyclicRefs_ == null) {
	    throw (new InternalError());
	}
	return (cyclicRefs_.contains(target));
    }

    // static
    private static int nextId__ = 1;
}
