/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * ESequenceNode
 *
 * @since   Jan. 10, 2000
 * @version Jul. 25, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class ESequenceNode extends ENode implements IEOccurs {
    private int occurs_;

    public ESequenceNode() {
	this(OCCURS_ONE);
    }

    public ESequenceNode(int occurs) {
	super("sequence");
	occurs_ = occurs;
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public ESequenceNode(ESequenceNode seq) {
	super(seq);
	setOccurs(seq.getOccurs());
	addChildrenDeep(seq);
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
