/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.jaba2.xml.relax.expanded.rText.*;

/**
 * TextPattern
 *
 * @since   Nov.  9, 2002
 * @version Nov. 11, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class TextPattern {
    private PPattern pattern_;

    public TextPattern(PPattern pattern) {
	pattern_ = pattern;
    }

    public PPattern getPattern() {
	return (pattern_);
    }

    public String getTextDocument() {
	StringBuffer buffer = new StringBuffer();
	IPTextPatternChoice[] patterns = pattern_.getTextPattern();
	for (int i = 0;i < patterns.length;i++) {
	    patterns[i].makeTextElement(buffer);
	}
	return (new String(buffer).replace('"', '\''));	// XXX : handle by relaxer object
    }

    public boolean isList() {
	if (pattern_.getTextPatternCount() == 1) {
	    return (pattern_.getTextPattern(0) instanceof PList);
	} else {
	    return (false);
	}
    }

    public IPTextPatternChoice[] getContents() {
	try {
	    PPattern pattern = new PPattern(pattern_.makeDocument());
	    return (pattern.getTextPattern());
	} catch (ParserConfigurationException e) {
	    throw (new InternalError());
	}
    }
}
