package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * AbstractRelaxNgFactory is generated by Relaxer based on relaxNg.rxm.
 *
 * @version relaxNg.rxm 1.0 (Sun May 18 08:58:10 JST 2003)
 * @author  Relaxer 1.0rc2b (http://www.relaxer.org)
 */
public abstract class AbstractRelaxNgFactory implements IRelaxNgFactory {
    protected org.xml.sax.ErrorHandler errorHandler;
    protected org.xml.sax.EntityResolver entityResolver;
    protected String baseUri;

    /**
     * Sets a <b>errorHandler</b>.
     *
     * @param errorHandler
     */
    public void setErrorHandler(org.xml.sax.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /**
     * Gets a <b>errorHandler</b>.
     *
     * @return org.xml.sax.ErrorHandler
     */
    public org.xml.sax.ErrorHandler getErrorHandler() {
        return (errorHandler);
    }

    /**
     * Sets a <b>entityResolver</b>.
     *
     * @param entityResolver
     */
    public void setEntityResolver(org.xml.sax.EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    /**
     * Gets a <b>entityResolver</b>.
     *
     * @return org.xml.sax.EntityResolver
     */
    public org.xml.sax.EntityResolver getEntityResolver() {
        return (entityResolver);
    }

    /**
     * Sets a <b>baseUri</b>.
     *
     * @param baseUri
     */
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    /**
     * Gets a <b>baseUri</b>.
     *
     * @return String
     */
    public String getBaseUri() {
        return (baseUri);
    }

    /**
     * Creates a <code>Object</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(File file) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(String uri) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(URL url) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the copy <code>Object</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Object source) throws IOException, SAXException, ParserConfigurationException {
        if (source instanceof RNGrammar) {
            RNGrammar node = createRNGrammar();
            node.setup((RNGrammar)source);
            return(node);
        } else if (source instanceof RNDefine) {
            RNDefine node = createRNDefine();
            node.setup((RNDefine)source);
            return(node);
        } else if (source instanceof RNElement) {
            RNElement node = createRNElement();
            node.setup((RNElement)source);
            return(node);
        } else if (source instanceof RNNsName) {
            RNNsName node = createRNNsName();
            node.setup((RNNsName)source);
            return(node);
        } else if (source instanceof RNExcept) {
            RNExcept node = createRNExcept();
            node.setup((RNExcept)source);
            return(node);
        } else if (source instanceof RNName) {
            RNName node = createRNName();
            node.setup((RNName)source);
            return(node);
        } else if (source instanceof RNAnyName) {
            RNAnyName node = createRNAnyName();
            node.setup((RNAnyName)source);
            return(node);
        } else if (source instanceof RNNameChoice) {
            RNNameChoice node = createRNNameChoice();
            node.setup((RNNameChoice)source);
            return(node);
        } else if (source instanceof RNAttribute) {
            RNAttribute node = createRNAttribute();
            node.setup((RNAttribute)source);
            return(node);
        } else if (source instanceof RNData) {
            RNData node = createRNData();
            node.setup((RNData)source);
            return(node);
        } else if (source instanceof RNParam) {
            RNParam node = createRNParam();
            node.setup((RNParam)source);
            return(node);
        } else if (source instanceof RNValue) {
            RNValue node = createRNValue();
            node.setup((RNValue)source);
            return(node);
        } else if (source instanceof RNRef) {
            RNRef node = createRNRef();
            node.setup((RNRef)source);
            return(node);
        } else if (source instanceof RNList) {
            RNList node = createRNList();
            node.setup((RNList)source);
            return(node);
        } else if (source instanceof RNTextChoice) {
            RNTextChoice node = createRNTextChoice();
            node.setup((RNTextChoice)source);
            return(node);
        } else if (source instanceof RNTextOptional) {
            RNTextOptional node = createRNTextOptional();
            node.setup((RNTextOptional)source);
            return(node);
        } else if (source instanceof RNTextOneOrMore) {
            RNTextOneOrMore node = createRNTextOneOrMore();
            node.setup((RNTextOneOrMore)source);
            return(node);
        } else if (source instanceof RNTextZeroOrMore) {
            RNTextZeroOrMore node = createRNTextZeroOrMore();
            node.setup((RNTextZeroOrMore)source);
            return(node);
        } else if (source instanceof RNText) {
            RNText node = createRNText();
            node.setup((RNText)source);
            return(node);
        } else if (source instanceof RNNotAllowed) {
            RNNotAllowed node = createRNNotAllowed();
            node.setup((RNNotAllowed)source);
            return(node);
        } else if (source instanceof RNEmpty) {
            RNEmpty node = createRNEmpty();
            node.setup((RNEmpty)source);
            return(node);
        } else if (source instanceof RNTextGroup) {
            RNTextGroup node = createRNTextGroup();
            node.setup((RNTextGroup)source);
            return(node);
        } else if (source instanceof RNTextExcept) {
            RNTextExcept node = createRNTextExcept();
            node.setup((RNTextExcept)source);
            return(node);
        } else if (source instanceof RNExternalRef) {
            RNExternalRef node = createRNExternalRef();
            node.setup((RNExternalRef)source);
            return(node);
        } else if (source instanceof RNParentRef) {
            RNParentRef node = createRNParentRef();
            node.setup((RNParentRef)source);
            return(node);
        } else if (source instanceof RNInterleave) {
            RNInterleave node = createRNInterleave();
            node.setup((RNInterleave)source);
            return(node);
        } else if (source instanceof RNZeroOrMore) {
            RNZeroOrMore node = createRNZeroOrMore();
            node.setup((RNZeroOrMore)source);
            return(node);
        } else if (source instanceof RNOneOrMore) {
            RNOneOrMore node = createRNOneOrMore();
            node.setup((RNOneOrMore)source);
            return(node);
        } else if (source instanceof RNGroup) {
            RNGroup node = createRNGroup();
            node.setup((RNGroup)source);
            return(node);
        } else if (source instanceof RNChoice) {
            RNChoice node = createRNChoice();
            node.setup((RNChoice)source);
            return(node);
        } else if (source instanceof RNMixed) {
            RNMixed node = createRNMixed();
            node.setup((RNMixed)source);
            return(node);
        } else if (source instanceof RNOptional) {
            RNOptional node = createRNOptional();
            node.setup((RNOptional)source);
            return(node);
        } else if (source instanceof RNStart) {
            RNStart node = createRNStart();
            node.setup((RNStart)source);
            return(node);
        } else if (source instanceof RNInclude) {
            RNInclude node = createRNInclude();
            node.setup((RNInclude)source);
            return(node);
        } else if (source instanceof RNDiv) {
            RNDiv node = createRNDiv();
            node.setup((RNDiv)source);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>Object</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Document doc) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(doc.getDocumentElement());
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Element element) throws IOException, SAXException, ParserConfigurationException {
        if (RNGrammar.isMatch(element)) {
            RNGrammar node = createRNGrammar();
            node.setup(element);
            return(node);
        } else if (RNDefine.isMatch(element)) {
            RNDefine node = createRNDefine();
            node.setup(element);
            return(node);
        } else if (RNElement.isMatch(element)) {
            RNElement node = createRNElement();
            node.setup(element);
            return(node);
        } else if (RNNsName.isMatch(element)) {
            RNNsName node = createRNNsName();
            node.setup(element);
            return(node);
        } else if (RNExcept.isMatch(element)) {
            RNExcept node = createRNExcept();
            node.setup(element);
            return(node);
        } else if (RNName.isMatch(element)) {
            RNName node = createRNName();
            node.setup(element);
            return(node);
        } else if (RNAnyName.isMatch(element)) {
            RNAnyName node = createRNAnyName();
            node.setup(element);
            return(node);
        } else if (RNNameChoice.isMatch(element)) {
            RNNameChoice node = createRNNameChoice();
            node.setup(element);
            return(node);
        } else if (RNAttribute.isMatch(element)) {
            RNAttribute node = createRNAttribute();
            node.setup(element);
            return(node);
        } else if (RNData.isMatch(element)) {
            RNData node = createRNData();
            node.setup(element);
            return(node);
        } else if (RNParam.isMatch(element)) {
            RNParam node = createRNParam();
            node.setup(element);
            return(node);
        } else if (RNValue.isMatch(element)) {
            RNValue node = createRNValue();
            node.setup(element);
            return(node);
        } else if (RNRef.isMatch(element)) {
            RNRef node = createRNRef();
            node.setup(element);
            return(node);
        } else if (RNList.isMatch(element)) {
            RNList node = createRNList();
            node.setup(element);
            return(node);
        } else if (RNTextChoice.isMatch(element)) {
            RNTextChoice node = createRNTextChoice();
            node.setup(element);
            return(node);
        } else if (RNTextOptional.isMatch(element)) {
            RNTextOptional node = createRNTextOptional();
            node.setup(element);
            return(node);
        } else if (RNTextOneOrMore.isMatch(element)) {
            RNTextOneOrMore node = createRNTextOneOrMore();
            node.setup(element);
            return(node);
        } else if (RNTextZeroOrMore.isMatch(element)) {
            RNTextZeroOrMore node = createRNTextZeroOrMore();
            node.setup(element);
            return(node);
        } else if (RNText.isMatch(element)) {
            RNText node = createRNText();
            node.setup(element);
            return(node);
        } else if (RNNotAllowed.isMatch(element)) {
            RNNotAllowed node = createRNNotAllowed();
            node.setup(element);
            return(node);
        } else if (RNEmpty.isMatch(element)) {
            RNEmpty node = createRNEmpty();
            node.setup(element);
            return(node);
        } else if (RNTextGroup.isMatch(element)) {
            RNTextGroup node = createRNTextGroup();
            node.setup(element);
            return(node);
        } else if (RNTextExcept.isMatch(element)) {
            RNTextExcept node = createRNTextExcept();
            node.setup(element);
            return(node);
        } else if (RNExternalRef.isMatch(element)) {
            RNExternalRef node = createRNExternalRef();
            node.setup(element);
            return(node);
        } else if (RNParentRef.isMatch(element)) {
            RNParentRef node = createRNParentRef();
            node.setup(element);
            return(node);
        } else if (RNInterleave.isMatch(element)) {
            RNInterleave node = createRNInterleave();
            node.setup(element);
            return(node);
        } else if (RNZeroOrMore.isMatch(element)) {
            RNZeroOrMore node = createRNZeroOrMore();
            node.setup(element);
            return(node);
        } else if (RNOneOrMore.isMatch(element)) {
            RNOneOrMore node = createRNOneOrMore();
            node.setup(element);
            return(node);
        } else if (RNGroup.isMatch(element)) {
            RNGroup node = createRNGroup();
            node.setup(element);
            return(node);
        } else if (RNChoice.isMatch(element)) {
            RNChoice node = createRNChoice();
            node.setup(element);
            return(node);
        } else if (RNMixed.isMatch(element)) {
            RNMixed node = createRNMixed();
            node.setup(element);
            return(node);
        } else if (RNOptional.isMatch(element)) {
            RNOptional node = createRNOptional();
            node.setup(element);
            return(node);
        } else if (RNStart.isMatch(element)) {
            RNStart node = createRNStart();
            node.setup(element);
            return(node);
        } else if (RNInclude.isMatch(element)) {
            RNInclude node = createRNInclude();
            node.setup(element);
            return(node);
        } else if (RNDiv.isMatch(element)) {
            RNDiv node = createRNDiv();
            node.setup(element);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>RNGrammar</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(File file) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(File file) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(File file) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(File file) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(File file) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(File file) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(File file) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(File file) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(File file) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(File file) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(File file) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(File file) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(File file) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(File file) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(File file) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(File file) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(File file) throws IOException, SAXException, ParserConfigurationException {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(File file) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(File file) throws IOException, SAXException, ParserConfigurationException {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(File file) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(File file) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(File file) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(File file) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(File file) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(File file) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(File file) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(String uri) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(URL url) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName();
        rNName_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData();
        rNData_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList();
        rNList_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText();
        rNText_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(RNGrammar source) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(source);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNDefine
     */
    public RNDefine createRNDefine(RNDefine source) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(source);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNElement
     */
    public RNElement createRNElement(RNElement source) {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(source);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNNsName
     */
    public RNNsName createRNNsName(RNNsName source) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(source);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNExcept
     */
    public RNExcept createRNExcept(RNExcept source) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(source);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNName
     */
    public RNName createRNName(RNName source) {
        RNName rNName_ = createRNName();
        rNName_.setup(source);
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(RNAnyName source) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(source);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(RNNameChoice source) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(source);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(RNAttribute source) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(source);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNData
     */
    public RNData createRNData(RNData source) {
        RNData rNData_ = createRNData();
        rNData_.setup(source);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNParam
     */
    public RNParam createRNParam(RNParam source) {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(source);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNValue
     */
    public RNValue createRNValue(RNValue source) {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(source);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNRef
     */
    public RNRef createRNRef(RNRef source) {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(source);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNList
     */
    public RNList createRNList(RNList source) {
        RNList rNList_ = createRNList();
        rNList_.setup(source);
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(RNTextChoice source) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(source);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(RNTextOptional source) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(source);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(RNTextOneOrMore source) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(source);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(RNTextZeroOrMore source) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(source);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNText
     */
    public RNText createRNText(RNText source) {
        RNText rNText_ = createRNText();
        rNText_.setup(source);
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(RNNotAllowed source) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(source);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(RNEmpty source) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(source);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(RNTextGroup source) {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(source);
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(RNTextExcept source) {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(source);
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(RNExternalRef source) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(source);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(RNParentRef source) {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(source);
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(RNInterleave source) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(source);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(RNZeroOrMore source) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(source);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(RNOneOrMore source) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(source);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNGroup
     */
    public RNGroup createRNGroup(RNGroup source) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(source);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNChoice
     */
    public RNChoice createRNChoice(RNChoice source) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(source);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNMixed
     */
    public RNMixed createRNMixed(RNMixed source) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(source);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNOptional
     */
    public RNOptional createRNOptional(RNOptional source) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(source);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNStart
     */
    public RNStart createRNStart(RNStart source) {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(source);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNInclude
     */
    public RNInclude createRNInclude(RNInclude source) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(source);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNDiv
     */
    public RNDiv createRNDiv(RNDiv source) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(source);
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Document doc) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(doc);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNDefine
     */
    public RNDefine createRNDefine(Document doc) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(doc);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNElement
     */
    public RNElement createRNElement(Document doc) {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(doc);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNNsName
     */
    public RNNsName createRNNsName(Document doc) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(doc);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNExcept
     */
    public RNExcept createRNExcept(Document doc) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(doc);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNName
     */
    public RNName createRNName(Document doc) {
        RNName rNName_ = createRNName();
        rNName_.setup(doc);
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Document doc) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(doc);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Document doc) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(doc);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Document doc) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(doc);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNData
     */
    public RNData createRNData(Document doc) {
        RNData rNData_ = createRNData();
        rNData_.setup(doc);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNParam
     */
    public RNParam createRNParam(Document doc) {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(doc);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNValue
     */
    public RNValue createRNValue(Document doc) {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(doc);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNRef
     */
    public RNRef createRNRef(Document doc) {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(doc);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNList
     */
    public RNList createRNList(Document doc) {
        RNList rNList_ = createRNList();
        rNList_.setup(doc);
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Document doc) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(doc);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Document doc) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(doc);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Document doc) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(doc);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Document doc) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(doc);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNText
     */
    public RNText createRNText(Document doc) {
        RNText rNText_ = createRNText();
        rNText_.setup(doc);
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Document doc) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(doc);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Document doc) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(doc);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(Document doc) {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(doc);
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(Document doc) {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(doc);
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Document doc) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(doc);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(Document doc) {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(doc);
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Document doc) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(doc);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Document doc) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(doc);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Document doc) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(doc);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNGroup
     */
    public RNGroup createRNGroup(Document doc) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(doc);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNChoice
     */
    public RNChoice createRNChoice(Document doc) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(doc);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNMixed
     */
    public RNMixed createRNMixed(Document doc) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(doc);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNOptional
     */
    public RNOptional createRNOptional(Document doc) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(doc);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNStart
     */
    public RNStart createRNStart(Document doc) {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(doc);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNInclude
     */
    public RNInclude createRNInclude(Document doc) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(doc);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNDiv
     */
    public RNDiv createRNDiv(Document doc) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(doc);
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Element element) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(element);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNDefine
     */
    public RNDefine createRNDefine(Element element) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(element);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNElement
     */
    public RNElement createRNElement(Element element) {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(element);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNNsName
     */
    public RNNsName createRNNsName(Element element) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(element);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNExcept
     */
    public RNExcept createRNExcept(Element element) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(element);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNName
     */
    public RNName createRNName(Element element) {
        RNName rNName_ = createRNName();
        rNName_.setup(element);
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Element element) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(element);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Element element) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(element);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Element element) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(element);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNData
     */
    public RNData createRNData(Element element) {
        RNData rNData_ = createRNData();
        rNData_.setup(element);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNParam
     */
    public RNParam createRNParam(Element element) {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(element);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNValue
     */
    public RNValue createRNValue(Element element) {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(element);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNRef
     */
    public RNRef createRNRef(Element element) {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(element);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNList
     */
    public RNList createRNList(Element element) {
        RNList rNList_ = createRNList();
        rNList_.setup(element);
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Element element) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(element);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Element element) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(element);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Element element) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(element);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Element element) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(element);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNText
     */
    public RNText createRNText(Element element) {
        RNText rNText_ = createRNText();
        rNText_.setup(element);
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Element element) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(element);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Element element) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(element);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(Element element) {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(element);
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(Element element) {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(element);
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Element element) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(element);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(Element element) {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(element);
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Element element) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(element);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Element element) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(element);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Element element) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(element);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNGroup
     */
    public RNGroup createRNGroup(Element element) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(element);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNChoice
     */
    public RNChoice createRNChoice(Element element) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(element);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNMixed
     */
    public RNMixed createRNMixed(Element element) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(element);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNOptional
     */
    public RNOptional createRNOptional(Element element) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(element);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNStart
     */
    public RNStart createRNStart(Element element) {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(element);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNInclude
     */
    public RNInclude createRNInclude(Element element) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(element);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNDiv
     */
    public RNDiv createRNDiv(Element element) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(element);
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(RStack stack) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.setup(stack);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNDefine
     */
    public RNDefine createRNDefine(RStack stack) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.setup(stack);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNElement
     */
    public RNElement createRNElement(RStack stack) {
        RNElement rNElement_ = createRNElement();
        rNElement_.setup(stack);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNNsName
     */
    public RNNsName createRNNsName(RStack stack) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.setup(stack);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNExcept
     */
    public RNExcept createRNExcept(RStack stack) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.setup(stack);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNName
     */
    public RNName createRNName(RStack stack) {
        RNName rNName_ = createRNName();
        rNName_.setup(stack);
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(RStack stack) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.setup(stack);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(RStack stack) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.setup(stack);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(RStack stack) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.setup(stack);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNData</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNData
     */
    public RNData createRNData(RStack stack) {
        RNData rNData_ = createRNData();
        rNData_.setup(stack);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNParam
     */
    public RNParam createRNParam(RStack stack) {
        RNParam rNParam_ = createRNParam();
        rNParam_.setup(stack);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNValue
     */
    public RNValue createRNValue(RStack stack) {
        RNValue rNValue_ = createRNValue();
        rNValue_.setup(stack);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNRef
     */
    public RNRef createRNRef(RStack stack) {
        RNRef rNRef_ = createRNRef();
        rNRef_.setup(stack);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNList
     */
    public RNList createRNList(RStack stack) {
        RNList rNList_ = createRNList();
        rNList_.setup(stack);
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(RStack stack) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.setup(stack);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(RStack stack) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.setup(stack);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(RStack stack) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.setup(stack);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(RStack stack) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.setup(stack);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNText
     */
    public RNText createRNText(RStack stack) {
        RNText rNText_ = createRNText();
        rNText_.setup(stack);
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(RStack stack) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.setup(stack);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(RStack stack) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.setup(stack);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(RStack stack) {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.setup(stack);
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(RStack stack) {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.setup(stack);
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(RStack stack) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.setup(stack);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(RStack stack) {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.setup(stack);
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(RStack stack) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.setup(stack);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(RStack stack) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.setup(stack);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(RStack stack) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.setup(stack);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNGroup
     */
    public RNGroup createRNGroup(RStack stack) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.setup(stack);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNChoice
     */
    public RNChoice createRNChoice(RStack stack) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.setup(stack);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNMixed
     */
    public RNMixed createRNMixed(RStack stack) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.setup(stack);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNOptional
     */
    public RNOptional createRNOptional(RStack stack) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.setup(stack);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNStart</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNStart
     */
    public RNStart createRNStart(RStack stack) {
        RNStart rNStart_ = createRNStart();
        rNStart_.setup(stack);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNInclude
     */
    public RNInclude createRNInclude(RStack stack) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.setup(stack);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNDiv
     */
    public RNDiv createRNDiv(RStack stack) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.setup(stack);
        return (rNDiv_);
    }
}
