package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNAttribute</b> is generated from relaxNg.rxm by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="attribute">
 *   <tag name="attribute">
 *     <attribute name="name" type="ngToken"/>
 *     <attribute name="ns" type="ngURI"/>
 *     <attribute name="datatypeLibrary" type="ngURI"/>
 *   </tag>
 *   <sequence>
 *     <hedgeRef label="nameClassHedge" occurs="?"/>
 *     <hedgeRef label="textHedge" occurs="?"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="attribute"&gt;
 *   &lt;tag name="attribute"&gt;
 *     &lt;attribute name="name" type="ngToken"/&gt;
 *     &lt;attribute name="ns" type="ngURI"/&gt;
 *     &lt;attribute name="datatypeLibrary" type="ngURI"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;hedgeRef label="nameClassHedge" occurs="?"/&gt;
 *     &lt;hedgeRef label="textHedge" occurs="?"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Sun May 18 08:58:08 JST 2003)
 * @author  Relaxer 1.0rc2b (http://www.relaxer.org)
 */
public class RNAttribute implements java.io.Serializable, Cloneable, IRNSContainer, IRNTextHedgeChoice, IRNDataChoice, IRNTextGroupChoice, IRNTextExceptChoice, IRVisitable, IRNode, IRNElementHedgeChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private String name_;
    private String ns_;
    private String datatypeLibrary_;
    private IRNNameClassHedgeChoice nameClassHedge_;
    private IRNTextHedgeChoice textHedge_;
    private Element xmlElement;
    private java.util.Map $directAttributes$_ = new java.util.HashMap();
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNAttribute</code>.
     *
     */
    public RNAttribute() {
    }

    /**
     * Creates a <code>RNAttribute</code>.
     *
     * @param source
     */
    public RNAttribute(RNAttribute source) {
        setup(source);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNAttribute(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNAttribute(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNAttribute</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNAttribute(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNAttribute</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNAttribute(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNAttribute</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNAttribute(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNAttribute</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNAttribute(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNAttribute(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNAttribute(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNAttribute(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNAttribute</code> by the RNAttribute <code>source</code>.
     *
     * @param source
     */
    public void setup(RNAttribute source) {
        int size;
        setName(source.getName());
        setNs(source.getNs());
        setDatatypeLibrary(source.getDatatypeLibrary());
        setNameClassHedge((IRNNameClassHedgeChoice)source.getNameClassHedge());
        setTextHedge((IRNTextHedgeChoice)source.getTextHedge());
    }

    /**
     * Initializes the <code>RNAttribute</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNAttribute</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNAttribute</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        ns_ = URelaxer.getAttributePropertyAsString(element, "ns");
        datatypeLibrary_ = URelaxer.getAttributePropertyAsString(element, "datatypeLibrary");
        if (RNNsName.isMatch(stack)) {
            setNameClassHedge(factory.createRNNsName(stack));
        } else if (RNName.isMatch(stack)) {
            setNameClassHedge(factory.createRNName(stack));
        } else if (RNAnyName.isMatch(stack)) {
            setNameClassHedge(factory.createRNAnyName(stack));
        } else if (RNNameChoice.isMatch(stack)) {
            setNameClassHedge(factory.createRNNameChoice(stack));
        } else {
        }
        if (RNDefine.isMatch(stack)) {
            setTextHedge(factory.createRNDefine(stack));
        } else if (RNElement.isMatch(stack)) {
            setTextHedge(factory.createRNElement(stack));
        } else if (RNAttribute.isMatch(stack)) {
            setTextHedge(factory.createRNAttribute(stack));
        } else if (RNData.isMatch(stack)) {
            setTextHedge(factory.createRNData(stack));
        } else if (RNValue.isMatch(stack)) {
            setTextHedge(factory.createRNValue(stack));
        } else if (RNRef.isMatch(stack)) {
            setTextHedge(factory.createRNRef(stack));
        } else if (RNList.isMatch(stack)) {
            setTextHedge(factory.createRNList(stack));
        } else if (RNTextChoice.isMatch(stack)) {
            setTextHedge(factory.createRNTextChoice(stack));
        } else if (RNTextOptional.isMatch(stack)) {
            setTextHedge(factory.createRNTextOptional(stack));
        } else if (RNTextOneOrMore.isMatch(stack)) {
            setTextHedge(factory.createRNTextOneOrMore(stack));
        } else if (RNTextZeroOrMore.isMatch(stack)) {
            setTextHedge(factory.createRNTextZeroOrMore(stack));
        } else if (RNText.isMatch(stack)) {
            setTextHedge(factory.createRNText(stack));
        } else if (RNNotAllowed.isMatch(stack)) {
            setTextHedge(factory.createRNNotAllowed(stack));
        } else if (RNEmpty.isMatch(stack)) {
            setTextHedge(factory.createRNEmpty(stack));
        } else if (RNTextGroup.isMatch(stack)) {
            setTextHedge(factory.createRNTextGroup(stack));
        } else if (RNTextExcept.isMatch(stack)) {
            setTextHedge(factory.createRNTextExcept(stack));
        } else {
        }
        URelaxer.getAttributeHungry(stack, "name");
        URelaxer.getAttributeHungry(stack, "ns");
        URelaxer.getAttributeHungry(stack, "datatypeLibrary");
        stack.addDirectAttributes($directAttributes$_);
    }

    /**
     * @return Object
     */
    public Object clone() {
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        return (factory.createRNAttribute(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "attribute");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.ns_ != null) {
            URelaxer.setAttributePropertyByString(element, "ns", this.ns_);
        }
        if (this.datatypeLibrary_ != null) {
            URelaxer.setAttributePropertyByString(element, "datatypeLibrary", this.datatypeLibrary_);
        }
        if (this.nameClassHedge_ != null) {
            this.nameClassHedge_.makeElement(element);
        }
        if (this.textHedge_ != null) {
            this.textHedge_.makeElement(element);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            element.setAttribute(key, rGetAttribute(key));
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNAttribute</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNAttribute</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNAttribute</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNAttribute</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNAttribute</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNAttribute</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>ns</b>.
     *
     * @return String
     */
    public final String getNs() {
        return (ns_);
    }

    /**
     * Sets the String property <b>ns</b>.
     *
     * @param ns
     */
    public final void setNs(String ns) {
        this.ns_ = ns;
    }

    /**
     * Gets the String property <b>datatypeLibrary</b>.
     *
     * @return String
     */
    public final String getDatatypeLibrary() {
        return (datatypeLibrary_);
    }

    /**
     * Sets the String property <b>datatypeLibrary</b>.
     *
     * @param datatypeLibrary
     */
    public final void setDatatypeLibrary(String datatypeLibrary) {
        this.datatypeLibrary_ = datatypeLibrary;
    }

    /**
     * Gets the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @return IRNNameClassHedgeChoice
     */
    public final IRNNameClassHedgeChoice getNameClassHedge() {
        return (nameClassHedge_);
    }

    /**
     * Sets the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @param nameClassHedge
     */
    public final void setNameClassHedge(IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_ = nameClassHedge;
        if (nameClassHedge != null) {
            nameClassHedge.rSetParentRNode(this);
        }
    }

    /**
     * Gets the IRNTextHedgeChoice property <b>textHedge</b>.
     *
     * @return IRNTextHedgeChoice
     */
    public final IRNTextHedgeChoice getTextHedge() {
        return (textHedge_);
    }

    /**
     * Sets the IRNTextHedgeChoice property <b>textHedge</b>.
     *
     * @param textHedge
     */
    public final void setTextHedge(IRNTextHedgeChoice textHedge) {
        this.textHedge_ = textHedge;
        if (textHedge != null) {
            textHedge.rSetParentRNode(this);
        }
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "attribute", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.append(" ");
            buffer.append("name");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        if (ns_ != null) {
            buffer.append(" ");
            buffer.append("ns");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getNs())));
            buffer.append("\"");
        }
        if (datatypeLibrary_ != null) {
            buffer.append(" ");
            buffer.append("datatypeLibrary");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.append("\"");
        }
        if (nameClassHedge_ != null) {
            nameClassHedge_.makeTextAttribute(buffer);
        }
        if (textHedge_ != null) {
            textHedge_.makeTextAttribute(buffer);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.append(" ");
            buffer.append(key);
            buffer.append("=\"");
            buffer.append(rGetAttribute(key));
            buffer.append("\"");
        }
        buffer.append(">");
        if (nameClassHedge_ != null) {
            nameClassHedge_.makeTextElement(buffer);
        }
        if (textHedge_ != null) {
            textHedge_.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "attribute", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.write("<");
        URelaxer.makeQName(prefix, "attribute", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.write(" ");
            buffer.write("name");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        if (ns_ != null) {
            buffer.write(" ");
            buffer.write("ns");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getNs())));
            buffer.write("\"");
        }
        if (datatypeLibrary_ != null) {
            buffer.write(" ");
            buffer.write("datatypeLibrary");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.write("\"");
        }
        if (nameClassHedge_ != null) {
            nameClassHedge_.makeTextAttribute(buffer);
        }
        if (textHedge_ != null) {
            textHedge_.makeTextAttribute(buffer);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.write(" ");
            buffer.write(key);
            buffer.write("=\"");
            buffer.write(rGetAttribute(key));
            buffer.write("\"");
        }
        buffer.write(">");
        if (nameClassHedge_ != null) {
            nameClassHedge_.makeTextElement(buffer);
        }
        if (textHedge_ != null) {
            textHedge_.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "attribute", buffer);
        buffer.write(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "attribute", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.print(" ");
            buffer.print("name");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        if (ns_ != null) {
            buffer.print(" ");
            buffer.print("ns");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getNs())));
            buffer.print("\"");
        }
        if (datatypeLibrary_ != null) {
            buffer.print(" ");
            buffer.print("datatypeLibrary");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.print("\"");
        }
        if (nameClassHedge_ != null) {
            nameClassHedge_.makeTextAttribute(buffer);
        }
        if (textHedge_ != null) {
            textHedge_.makeTextAttribute(buffer);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.print(" ");
            buffer.print(key);
            buffer.print("=\"");
            buffer.print(rGetAttribute(key));
            buffer.print("\"");
        }
        buffer.print(">");
        if (nameClassHedge_ != null) {
            nameClassHedge_.makeTextElement(buffer);
        }
        if (textHedge_ != null) {
            textHedge_.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "attribute", buffer);
        buffer.print(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNsAsString() {
        return (URelaxer.getString(getNs()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDatatypeLibraryAsString() {
        return (URelaxer.getString(getDatatypeLibrary()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNsByString(String string) {
        setNs(URelaxer.getString(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDatatypeLibraryByString(String string) {
        setDatatypeLibrary(URelaxer.getString(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets a value of the attribute.
     *
     * @param qName
     * @return String
     */
    public String rGetAttribute(String qName) {
        return ((String)$directAttributes$_.get(qName));
    }

    /**
     * Sets a value of the attribute.
     *
     * @param qName
     * @param value
     */
    public void rSetAttribute(String qName, String value) {
        $directAttributes$_.put(qName, value);
    }

    /**
     * Gets attribute keys.
     *
     * @return String[]
     */
    public String[] rGetAttributeKeys() {
        java.util.Set keys = $directAttributes$_.keySet();
        String[] result = new String[keys.size()];
        return ((String[])keys.toArray(result));
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (nameClassHedge_ != null) {
            classNodes.add(nameClassHedge_);
        }
        if (textHedge_ != null) {
            classNodes.add(textHedge_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNAttribute</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "attribute")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RNNsName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNAnyName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNNameChoice.isMatchHungry(target)) {
            $match$ = true;
        } else {
        }
        if (RNDefine.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNElement.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNAttribute.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNData.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNValue.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNList.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextChoice.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextOptional.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextOneOrMore.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextZeroOrMore.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNText.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNNotAllowed.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNEmpty.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextGroup.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNTextExcept.isMatchHungry(target)) {
            $match$ = true;
        } else {
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNAttribute</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNAttribute</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
