/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.io.Serializable;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import org.relaxer.tabular.*;

/**
 * CSVTabularBean
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class CSVTabularBean implements Serializable {
    private String url_;
    private String encoding_;
    private transient CSVTabular tabular_ = null;

    public CSVTabularBean() {
    }

    public final void setSource(String url) {
	url_ = url;
	tabular_ = null;
    }

    public final String getSource() {
	return (url_);
    }

    public final void setEncoding(String encoding) {
	encoding_ = encoding;
    }

    public final String getEncoding() {
	return (encoding_);
    }

    public CSVTabular getTabular() throws IOException {
	if (tabular_ == null) {
	    if (encoding_ != null) {
		tabular_ = new CSVTabular(new URL(url_), encoding_);
	    } else {
		tabular_ = new CSVTabular(new URL(url_));
	    }
	}
	return (tabular_);
    }
}
