/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.io.Serializable;
import java.sql.SQLException;
import javax.naming.NamingException;
import org.relaxer.tabular.*;

/**
 * JDBCTabularBean
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class JDBCTabularBean implements Serializable {
    private String url_;
    private transient String username_ = null;
    private transient String password_ = null;
    private String sql_;
    private transient JDBCTabular tabular_ = null;
    private String driver_ = null;

    public JDBCTabularBean() {
    }

    public final void setUrl(String url) {
	url_ = url;
	tabular_ = null;
    }

    public final String getUrl() {
	return (url_);
    }

    public final void setUsername(String username) {
	username_ = username;
    }

    public final String getUsername() {
	return (username_);
    }

    public final void setPassword(String password) {
	password_ = password;
    }

    public final String getPassword() {
	return (password_);
    }

    public final void setSql(String sql) {
	sql_ = sql;
    }

    public final String getSql() {
	return (sql_);
    }

    public final void setDriver(String driver) {
	driver_ = driver;
    }

    public JDBCTabular getTabular() throws SQLException {
	String username = username_;
	if (username == null) {
	    username = "";
	}
	String password = password_;
	if (password == null) {
	    password = "";
	}
	if (tabular_ == null) {
	    tabular_ = new JDBCTabular(
		url_,
		username,
		password,
		sql_,
		driver_
	    );
	}
	return (tabular_);
    }
}
