/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.w3c.dom.Document;

/**
 * RJDBCInsertBean
 *
 * @since   Feb.  1, 2001
 * @version Aug. 15, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RJDBCInsertBean extends AbstractRJDBCBean {
    public void insertRObject(Object rObject) throws SQLException {
	Object handle = _makeHandle();
	_insertObject(handle, rObject);
	_closeHandle(handle);
    }

    public void insertRObjects(Object[] rObjects) throws SQLException {
	Object handle = _makeHandle();
	_insertObjects(handle, rObjects);
	_closeHandle(handle);
    }

    private void _insertObject(
	Object handle,
	Object rObject
    ) throws SQLException {
	try {
	    Class[] types = { rObject.getClass() };
	    Method method = handle.getClass().getMethod("insert", types);
	    Object[] params = { rObject };
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} 
    }

    private void _insertObjects(
	Object handle,
	Object[] rObjects
    ) throws SQLException {
//	org.relaxer.monitor.ULog.setDebug(true);
	try {
	    int length = Array.getLength(rObjects);
	    if (length == 0) {
		return;
	    }
	    Object firstElement = Array.get(rObjects, 0);
	    Class type = firstElement.getClass();
	    Object array = Array.newInstance(type, length);
	    System.arraycopy(rObjects, 0, array, 0, length);
	    Class[] types = { array.getClass() };
	    Method method = handle.getClass().getMethod("insert", types);
	    Object[] params = { array };
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} 
    }

    public void insertDocument(Document doc) throws SQLException {
	Object handle = _makeHandle();
	_insertDocument(handle, doc);
	_closeHandle(handle);
    }

    public void insertDocuments(Document[] docs) throws SQLException {
	Object handle = _makeHandle();
	_insertDocuments(handle, docs);
	_closeHandle(handle);
    }

    private void _insertDocument(
	Object handle,
	Document doc
    ) throws SQLException {
	try {
	    Class[] types = { Document.class };
	    Method method = handle.getClass().getMethod("insert", types);
	    Object[] params = { doc };
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} 
    }

    private void _insertDocuments(
	Object handle,
	Document[] docs
    ) throws SQLException {
//	org.relaxer.monitor.ULog.setDebug(true);
	try {
	    int length = Array.getLength(docs);
	    if (length == 0) {
		return;
	    }
	    Class[] types = { docs.getClass() };
	    Method method = handle.getClass().getMethod("insert", types);
	    Object[] params = { docs };
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} 
    }
}
