/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.io.Serializable;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.relaxer.tabular.*;

/**
 * XMLTabularBean
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XMLTabularBean implements Serializable {
    private String uri_;
    private transient XMLTabular tabular_ = null;

    public XMLTabularBean() {
    }

    public final void setSource(String uri) {
	uri_ = uri;
	tabular_ = null;
    }

    public final String getSource() {
	return (uri_);
    }

    public XMLTabular getTabular()
	throws SAXException, IOException, ParserConfigurationException {

	if (tabular_ == null) {
	    tabular_ = new XMLTabular(uri_);
	}
	return (tabular_);
    }
}
