/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.util.*;
import java.io.*;
import java.lang.reflect.*;
import javax.xml.parsers.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.Source;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * XSLTBean
 *
 * @since   Oct.  7, 2000
 * @version Aug.  6, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XSLTBean implements Serializable {
    private Source input_;
    private Source xsl_;
    private Map params_ = new HashMap();

    public XSLTBean() {
    }

    public final void setSourceUri(String uri) {
	input_ = new StreamSource(uri);
    }

    public final void setSourceDocument(Document doc) {
	input_ = new DOMSource(doc);
    }

    public final void setSourceRObject(Object object) {
//ULog.log("XSLTBean.setSourceRObject(" + object + ")");
	if (_setSourceBySAX(object)) {
	} else if (_setSourceByDOM(object)) {
	} else {
	    throw (new IllegalArgumentException("no Relaxer object"));
	}
    }

    private boolean _setSourceBySAX(Object object) {
	return (false);
    }

    private boolean _setSourceByDOM(Object object) {
	try {
	    Class clazz = object.getClass();
	    Method method = clazz.getMethod(
		"makeElement",
		new Class[] { org.w3c.dom.Node.class }
	    );
	    DocumentBuilderFactory factory
		= DocumentBuilderFactory.newInstance();
	    DocumentBuilder builder = factory.newDocumentBuilder();
	    Document doc = builder.newDocument();
	    method.invoke(
		object,
		new Object[] { doc }
	    );
	    setSourceDocument(doc);
	    return (true);
	} catch (ParserConfigurationException e) {
	    return (false);
	} catch (NoSuchMethodException e) {
	    return (false);
	} catch (SecurityException e) {
	    return (false);
	} catch (IllegalAccessException e) {
	    return (false);
	} catch (InvocationTargetException e) {
	    return (false);
	}
    }

    public final void setXslUri(String uri) {
	xsl_ = new StreamSource(uri);
    }

    public final void setParams(String params) {
	if (params == null) {
	    return;
	}
	StringTokenizer st = new StringTokenizer(params, ";");
	while (st.hasMoreTokens()) {
	    String token = st.nextToken();
	    int index = token.indexOf(":");
	    if (index == -1) {
		continue;
	    }
	    String key = token.substring(0, index).trim();
	    String value = token.substring(index + 1).trim();
	    params_.put(key, value);
	}
    }

    public final String getSourceUri() {
	throw (new UnsupportedOperationException());
    }

    public final String getXslUri() {
	throw (new UnsupportedOperationException());
    }

    public final String getParams() {
	StringBuffer buffer = new StringBuffer();
	Set keys = params_.keySet();
	Iterator iter = keys.iterator();
	if (iter.hasNext()) {
	    _setKeyValue(iter, buffer);
	    while (iter.hasNext()) {
		buffer.append(";");
		_setKeyValue(iter, buffer);
	    }
	}
	return (new String(buffer));
    }

    private void _setKeyValue(Iterator iter, StringBuffer buffer) {
	String key = (String)iter.next();
	String value = (String)params_.get(key);
	buffer.append(key);
	buffer.append(":");
	buffer.append(value);
    }

    public final String transform() {
	try {
	    return (_transform(input_, xsl_, params_));
	} catch (SAXException e) {
	    return (_getDetailInfo(e));
	} catch (IOException e) {
	    return (_getDetailInfo(e));
	} catch (Exception e) {
	    return (_getDetailInfo(e));
	}
    }

    private String _getDetailInfo(Exception e) {
	StringWriter buffer = new StringWriter();
	PrintWriter writer = new PrintWriter(buffer);
	e.printStackTrace(writer);
	return (buffer.toString());
    }

    private String _transform(
	Source inputSource,
	Source xslSource,
	Map params
    ) throws SAXException, IOException {
	try {
	    StringWriter buffer = new StringWriter();
	    Result outputResult = new StreamResult(buffer);
	    TransformerFactory factory = TransformerFactory.newInstance();
	    Transformer transformer = factory.newTransformer(xslSource);
	    _setParams(transformer, params);
	    transformer.transform(inputSource, outputResult);
	    return (buffer.toString());
	} catch (TransformerConfigurationException e) {
	    return (_getDetailInfo(e));
	} catch (TransformerException e) {
	    return (_getDetailInfo(e));
	}
    }

    private void _setParams(Transformer transformer, Map params) {
	Set keys = params.keySet();
	Iterator iter = keys.iterator();
	while (iter.hasNext()) {
	    String key = (String)iter.next();
	    String value = (String)params.get(key);
	    transformer.setParameter(key, value);
	}
    }
}
