/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus.framework;

import org.relaxer.bus.*;
import org.relaxer.bus.model.*;

/**
 * RBusPipe
 *
 * @since   Jan.  1, 2002
 * @version Jan.  3, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RBusPipe extends AbstractRBusFramework {
    public IRBusSignal stimulas(IRBusSignal signal) {
	int nParts = partCount();
	for (int i = 0;i < nParts;i++) {
	    IRBusPart part = getPart(i);
	    signal = part.stimulas(signal);
	}
	return (signal);
    }
}
