/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog;

import java.util.*;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.relaxer.dialog.rDialog.*;

/**
 * SimpleDialogSpace
 *
 * @since   Jul.  6, 2001
 * @version Feb. 27, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class SimpleDialogSpace extends AbstractDialogSpace {
    private Map slots_ = new HashMap();
    private List slotList_ = new ArrayList();
    private Map commands_ = new HashMap();
    private List commandList_ = new ArrayList();

    public SimpleDialogSpace(String uri)
	throws IOException,
	       ClassNotFoundException,
	       SAXException,
	       ParserConfigurationException {
	this(new DDialog(uri));
    }

    public SimpleDialogSpace(DDialog cDialog) throws ClassNotFoundException {
	super(cDialog.getName());
	DSlot[] cSlots = cDialog.getSlot();
	for (int i = 0;i < cSlots.length;i++) {
	    setSlot(new SimpleDialogSlot(cSlots[i]));
	}
	DCommand[] cCommands = cDialog.getCommand();
	for (int i = 0;i < cCommands.length;i++) {
	    setCommand(new SimpleDialogCommand(cCommands[i], this));
	}
    }

    public void setSlot(IDialogSlot slot) {
	slot.setDialogSpace(this);
	slots_.put(slot.getName(), slot);
	slotList_.add(slot);
    }

    public IDialogSlot getSlot(String name) {
	return ((IDialogSlot)slots_.get(name));
    }

    public void setCommand(IDialogCommand command) {
	command.setDialogSpace(this);
	commands_.put(command.getName(), command);
	commandList_.add(command);
    }

    public IDialogCommand getCommand(String name) {
	return ((IDialogCommand)commands_.get(name));
    }

    public void open() throws IOException {
//System.out.println("open space");
	int size = slotList_.size();
	for (int i = 0;i < size;i++) {
	    IDialogSlot slot = (IDialogSlot)slotList_.get(i);
	    slot.load();
	}
    }

    public void close() throws IOException {
	flush();
    }

    public void flush() throws IOException {
	int size = slotList_.size();
	for (int i = 0;i < size;i++) {
	    IDialogSlot slot = (IDialogSlot)slotList_.get(i);
	    slot.save();
	}
    }
}
