/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog.eDialog;

import java.io.IOException;
import java.beans.Beans;
import java.lang.reflect.*;
import org.relaxer.dialog.*;
import org.relaxer.dialog.rDialog.*;

/**
 * EvalBeanAction
 *
 * @since   Feb. 27, 2002
 * @version Feb. 27, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class EvalBeanAction extends DBeanAction {
    public Object eval(Object[] params, IREvaluationContext context) {
	EvalContext cContext = (EvalContext)context;
	String beanName = getName();
	DGenericMethod genericMethod = getGenericMethod();
	DGenericParam[] genericParams = genericMethod.getGenericParam();
	Class[] typeList = new Class[genericParams.length];
	Object[] paramList = new Object[genericParams.length];
	for (int i = 0;i < genericParams.length;i++) {
	    DGenericParam genericParam = genericParams[i];
	    String slotName = genericParam.getSlot();
	    IDialogSlot slot = cContext.space.getSlot(slotName);
	    typeList[i] = slot.getType();
	    paramList[i] = slot.getRObject();
	}
	return (
	    _invoke(
		beanName,
		genericMethod.getName(),
		typeList,
		paramList
	    )
	);
    }

    private Object _invoke(
	String beanName,
	String methodName,
	Class[] typeList,
	Object[] paramList
    ) {
	try {
	    Object bean = Beans.instantiate(null, beanName);
	    Class beanClass = bean.getClass();
	    Method method = beanClass.getMethod(methodName, typeList);
	    return (method.invoke(bean, paramList));
	} catch (IOException e) {
	    throw (new InternalError(e.getMessage()));
	} catch (ClassNotFoundException e) {
	    throw (new InternalError(e.getMessage()));
	} catch (NoSuchMethodException e) {
	    throw (new InternalError(e.getMessage()));
	} catch (IllegalAccessException e) {
	    throw (new InternalError(e.getMessage()));
	} catch (IllegalArgumentException e) {
	    throw (new InternalError(e.getMessage()));
	} catch (InvocationTargetException e) {
	    throw (new InternalError(e.getMessage()));
	}
    }
}
