package org.relaxer.dialog.rDialog;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>DSwitch</b> is generated from dialog.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="switch">
 *   <ref name="evaluatable"/>
 *   <zeroOrMore>
 *     <ref name="case"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="switch"&gt;
 *   &lt;ref name="evaluatable"/&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="case"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version dialog.rng (Tue Jun 03 11:20:59 GMT+09:00 2003)
 * @author  Relaxer 1.0beta (http://www.relaxer.org)
 */
public class DSwitch implements java.io.Serializable, Cloneable, IREvaluatable, IRNode, IDEvaluatableChoice {
    private IDEvaluatableChoice evaluatable_;
    // List<DCase>
    private java.util.List case_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>DSwitch</code>.
     *
     */
    public DSwitch() {
    }

    /**
     * Creates a <code>DSwitch</code>.
     *
     * @param source
     */
    public DSwitch(DSwitch source) {
        setup(source);
    }

    /**
     * Creates a <code>DSwitch</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public DSwitch(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>DSwitch</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public DSwitch(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>DSwitch</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public DSwitch(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>DSwitch</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSwitch(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>DSwitch</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSwitch(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>DSwitch</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSwitch(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>DSwitch</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSwitch(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>DSwitch</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSwitch(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>DSwitch</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DSwitch(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>DSwitch</code> by the DSwitch <code>source</code>.
     *
     * @param source
     */
    public void setup(DSwitch source) {
        int size;
        setEvaluatable((IDEvaluatableChoice)source.getEvaluatable());
        this.case_.clear();
        size = source.case_.size();
        for (int i = 0;i < size;i++) {
            addCase((DCase)source.getCase(i).clone());
        }
    }

    /**
     * Initializes the <code>DSwitch</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>DSwitch</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>DSwitch</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IDialogFactory factory = DialogFactory.getFactory();
        RStack stack = new RStack(element);
        if (DEjbAction.isMatch(stack)) {
            setEvaluatable(factory.createDEjbAction(stack));
        } else if (DBeanAction.isMatch(stack)) {
            setEvaluatable(factory.createDBeanAction(stack));
        } else if (DJaxmAction.isMatch(stack)) {
            setEvaluatable(factory.createDJaxmAction(stack));
        } else if (DSwitch.isMatch(stack)) {
            setEvaluatable(factory.createDSwitch(stack));
        } else {
        }
        case_.clear();
        while (true) {
            if (DCase.isMatch(stack)) {
                addCase(factory.createDCase(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        IDialogFactory factory = DialogFactory.getFactory();
        return (factory.createDSwitch(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("switch");
        int size;
        if (this.evaluatable_ != null) {
            this.evaluatable_.makeElement(element);
        }
        size = this.case_.size();
        for (int i = 0;i < size;i++) {
            DCase value = (DCase)this.case_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>DSwitch</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>DSwitch</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DSwitch</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DSwitch</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DSwitch</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DSwitch</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the IDEvaluatableChoice property <b>evaluatable</b>.
     *
     * @return IDEvaluatableChoice
     */
    public final IDEvaluatableChoice getEvaluatable() {
        return (evaluatable_);
    }

    /**
     * Sets the IDEvaluatableChoice property <b>evaluatable</b>.
     *
     * @param evaluatable
     */
    public final void setEvaluatable(IDEvaluatableChoice evaluatable) {
        this.evaluatable_ = evaluatable;
        if (evaluatable != null) {
            evaluatable.rSetParentRNode(this);
        }
    }

    /**
     * Gets the DCase property <b>case</b>.
     *
     * @return DCase[]
     */
    public final DCase[] getCase() {
        DCase[] array = new DCase[case_.size()];
        return ((DCase[])case_.toArray(array));
    }

    /**
     * Sets the DCase property <b>case</b>.
     *
     * @param caseValue
     */
    public final void setCase(DCase[] caseValue) {
        this.case_.clear();
        for (int i = 0;i < caseValue.length;i++) {
            addCase(caseValue[i]);
        }
        for (int i = 0;i < caseValue.length;i++) {
            caseValue[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the DCase property <b>case</b>.
     *
     * @param caseValue
     */
    public final void setCase(DCase caseValue) {
        this.case_.clear();
        addCase(caseValue);
        if (caseValue != null) {
            caseValue.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DCase property <b>case</b>.
     *
     * @param caseValue
     */
    public final void addCase(DCase caseValue) {
        this.case_.add(caseValue);
        if (caseValue != null) {
            caseValue.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DCase property <b>case</b>.
     *
     * @param caseValue
     */
    public final void addCase(DCase[] caseValue) {
        for (int i = 0;i < caseValue.length;i++) {
            addCase(caseValue[i]);
        }
        for (int i = 0;i < caseValue.length;i++) {
            caseValue[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the DCase property <b>case</b>.
     *
     * @return int
     */
    public final int sizeCase() {
        return (case_.size());
    }

    /**
     * Gets the DCase property <b>case</b> by index.
     *
     * @param index
     * @return DCase
     */
    public final DCase getCase(int index) {
        return ((DCase)case_.get(index));
    }

    /**
     * Sets the DCase property <b>case</b> by index.
     *
     * @param index
     * @param caseValue
     */
    public final void setCase(int index, DCase caseValue) {
        this.case_.set(index, caseValue);
        if (caseValue != null) {
            caseValue.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DCase property <b>case</b> by index.
     *
     * @param index
     * @param caseValue
     */
    public final void addCase(int index, DCase caseValue) {
        this.case_.add(index, caseValue);
        if (caseValue != null) {
            caseValue.rSetParentRNode(this);
        }
    }

    /**
     * Remove the DCase property <b>case</b> by index.
     *
     * @param index
     */
    public final void removeCase(int index) {
        this.case_.remove(index);
    }

    /**
     * Remove the DCase property <b>case</b> by object.
     *
     * @param caseValue
     */
    public final void removeCase(DCase caseValue) {
        this.case_.remove(caseValue);
    }

    /**
     * Clear the DCase property <b>case</b>.
     *
     */
    public final void clearCase() {
        this.case_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<switch");
        if (evaluatable_ != null) {
            evaluatable_.makeTextAttribute(buffer);
        }
        buffer.append(">");
        if (evaluatable_ != null) {
            evaluatable_.makeTextElement(buffer);
        }
        size = this.case_.size();
        for (int i = 0;i < size;i++) {
            DCase value = (DCase)this.case_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</switch>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<switch");
        if (evaluatable_ != null) {
            evaluatable_.makeTextAttribute(buffer);
        }
        buffer.write(">");
        if (evaluatable_ != null) {
            evaluatable_.makeTextElement(buffer);
        }
        size = this.case_.size();
        for (int i = 0;i < size;i++) {
            DCase value = (DCase)this.case_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</switch>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<switch");
        if (evaluatable_ != null) {
            evaluatable_.makeTextAttribute(buffer);
        }
        buffer.print(">");
        if (evaluatable_ != null) {
            evaluatable_.makeTextElement(buffer);
        }
        size = this.case_.size();
        for (int i = 0;i < size;i++) {
            DCase value = (DCase)this.case_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</switch>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Evaluates the node.
     *
     * @return Object
     */
    public Object eval() {
        return (eval(new RSimpleEvaluationContext()));
    }

    /**
     * Evaluates the node with the evaluation context.
     *
     * @param context
     * @return Object
     */
    public Object eval(IREvaluationContext context) {
        IRNode[] children = rGetRNodes();
        Object[] params = new Object[children.length];
        for (int i = 0;i < children.length;i++) {
            IRNode child = children[i];
            if (child instanceof IREvaluatable) {
                params[i] = ((IREvaluatable)child).eval(context);
            } else {
                params[i] = child;
            }
        }
        return (eval(params, context));
    }

    /**
     * Evaluates against the params.
     *
     * @param params
     * @param context
     * @return Object
     */
    public Object eval(Object[] params, IREvaluationContext context) {
        if (params == null) {
            return (null);
        }
        if (params.length == 0) {
            return (null);
        }
        return (params[params.length -1]);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (evaluatable_ != null) {
            classNodes.add(evaluatable_);
        }
        classNodes.addAll(case_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>DSwitch</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "switch")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (DEjbAction.isMatchHungry(target)) {
            $match$ = true;
        } else if (DBeanAction.isMatchHungry(target)) {
            $match$ = true;
        } else if (DJaxmAction.isMatchHungry(target)) {
            $match$ = true;
        } else if (DSwitch.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        while (true) {
            if (!DCase.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DSwitch</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DSwitch</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
