/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.goldenport.ports.interpreter;

import java.util.*;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.w3c.dom.*;
import org.relaxer.xml.UDOM;
import org.relaxer.goldenport.*;
import org.relaxer.goldenport.selecter.AllSelecter;

/**
 * InterpreterPort
 *
 * @since   Jul.  6, 2002
 * @version Jul.  8, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class InterpreterPort extends AbstractPort {
    // Map<String, Atom>
    private Map atoms_ = new HashMap();

    public InterpreterPort() {
	_setup(new AllSelecter());
	Atom atom;
	//
//	atom = makeAtom("or");
//	atom.setPattern(new OrFexprPattern());
	//
//	atom = makeAtom("and");
//	atom.setPattern(new AndFexprPattern());
	//
	atom = makeAtom("copy-of");
	atom.setPattern(new CopyOfSubrPattern());
    }

    public InterpreterPort(Document doc) {
	this();
	Element[] defines
	    = UDOM.getElements(doc.getDocumentElement(), "define");
	for (int i = 0;i < defines.length;i++) {
	    _addDefine(defines[i]);
	}
    }

    public void setup(Element element) {
	NodeList macros = element.getElementsByTagNameNS(
	    "http://www.relaxer.org/xmlns/goldenport",
	    "macro"
	);
	int size = macros.getLength();
	for (int i = 0;i < size;i++) {
	    _setupMacro((Element)macros.item(i));
	}
    }

    private void _setupMacro(Element macro) {
	String uri = macro.getAttribute("src");
	if (!"".equals(uri)) {
	    try {
		Document doc = UDOM.loadDocumentNs(uri);
		Element root = doc.getDocumentElement();
//System.out.println(root.getLocalName());
		if ("macro".equals(root.getLocalName())) {
		    _setupMacro(root);
		}
	    } catch (IOException e) {
	    } catch (ParserConfigurationException e) {
	    } catch (SAXException e) {
	    }
	}
	_setupDefines(macro);
    }

    private void _setupDefines(Element macro) {
	NodeList defines = macro.getElementsByTagNameNS(
	    "http://www.relaxer.org/xmlns/goldenport",
	    "define"
	);
	int size = defines.getLength();
	for (int i = 0;i < size;i++) {
	    Element define = (Element)defines.item(i);
	    _addDefine(define);
	}
    }

    private void _addDefine(Element define) {
	String name = define.getAttribute("name");
	Atom atom = makeAtom(name);
	atom.setPattern(new ExprPattern(define));
    }

    public Atom makeAtom(String name) {
	Atom atom = getAtom(name);
	if (atom == null) {
	    atom = new Atom(name);
	}
	addAtom(atom);
	return (atom);
    }

    public Atom getAtom(String name) {
	return ((Atom)atoms_.get(name));
    }

    public void addAtom(Atom atom) {
	atoms_.put(atom.getName(), atom);
    }

    public int startElement(
	Element element,
	PortContext context,
	PortNodeList result
    ) {
	String name = element.getLocalName();
	if ("macro".equals(name)) {
	    if ("http://www.relaxer.org/xmlns/goldenport".equals(element.getNamespaceURI())) {
		return (EVAL_DONE);
	    }
	}
	Atom atom = (Atom)atoms_.get(name);
	if (atom != null) {
	    return (atom.startElement(element, context, result));
	} else {
	    result.setup(element);
	    return (EVAL_CHILDREN);
	}
    }

    public void endElement(
	Element element,
	PortNodeList children,
	PortContext context,
	PortNodeList result
    ) {
	String name = element.getLocalName();
	Atom atom = (Atom)atoms_.get(name);
	if (atom != null) {
	    atom.endElement(element, children, context, result);
	} else {
	    result.setup(children);
	}
    }
}
