/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.mom;

import java.io.*;
import javax.jms.*;
import org.relaxer.util.UException;

/**
 * BytesMessageStream
 *
 * @since   Jul. 17, 2001
 * @version Jul. 17, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class BytesMessageStream extends InputStream {
    private BytesMessage message_;

    public BytesMessageStream(BytesMessage message) {
	message_ = message;
    }

    public int read() throws IOException {
	try {
	    return (message_.readUnsignedByte());
	} catch (JMSException e) {
	    throw (UException.makeIOException(e));
	}
    }

    public int readBytes(byte[] buffer) throws IOException {
	try {
	    return (message_.readBytes(buffer));
	} catch (JMSException e) {
	    throw (UException.makeIOException(e));
	}
    }

    public int read(byte[] buffer) throws IOException {
	try {
	    return (message_.readBytes(buffer));
	} catch (JMSException e) {
	    throw (UException.makeIOException(e));
	}
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
	try {
	    if (off == 0) {
		return (message_.readBytes(buffer, len));
	    } else {
		return (super.read(buffer, off, len));
	    }
	} catch (JMSException e) {
	    throw (UException.makeIOException(e));
	}
    }
}
