/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.mom;

import javax.naming.*;
import javax.jms.*;
import org.relaxer.util.UException;

/**
 * MOMFacadeFactory
 *
 * @since   Jul. 17, 2001
 * @version Jul. 17, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class MOMFacadeFactory {
    protected MOMFacadeFactory() {
    }

    public static MOMFacadeFactory newInstance() {
	return (new MOMFacadeFactory());
    }

    public IMOMFacade getMOMFacade(
	String factoryUri,
	String destinationUri
    ) throws NamingException, JMSException {
	Context context = new InitialContext();
	Object factory = context.lookup(factoryUri);
	Object destination = context.lookup(destinationUri);
	if (factory instanceof QueueConnectionFactory) {
	    return (
		new QueueFacade(
		    (QueueConnectionFactory)factory,
		    destination
		)
	    );
	} else if (factory instanceof XAQueueConnectionFactory) {
	    return (
		new XAQueueFacade(
		    (XAQueueConnectionFactory)factory,
		    destination
		)
	    );
	} else if (factory instanceof TopicConnectionFactory) {
	    return (
		new TopicFacade(
		    (TopicConnectionFactory)factory,
		    destination
		)
	    );
	} else if (factory instanceof XATopicConnectionFactory) {
	    return (
		new XATopicFacade(
		    (XATopicConnectionFactory)factory,
		    destination
		)
	    );
	} else {
	    throw (new JMSException("Invalid factory = " + factory));
	}
    }
}
