/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.mom;

import java.io.IOException;
import javax.jms.*;
import org.relaxer.tabular.ITabular;

/**
 * TopicFacade
 *
 * @since   Jul. 17, 2001
 * @version Jul. 17, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class TopicFacade extends AbstractJmsFacade {
    private TopicConnectionFactory factory_ = null;
    private Topic topic_ = null;
    private TopicConnection connection_ = null;
    private TopicSession session_ = null;
    private TopicPublisher publisher_ = null;
    private TopicSubscriber subscriber_ = null;

    public TopicFacade(
	TopicConnectionFactory factory,
	Object destination
    ) throws JMSException {
	_setup(factory, destination);
    }

    public void close() {
	_release();
    }

    protected TopicFacade() {
    }

    protected void _setup(
	TopicConnectionFactory factory,
	Object destination
    ) throws JMSException {
	if (!(destination instanceof Topic)) {
	    throw (new JMSException("no topic = " + destination));
	}
	try {
	    factory_ = factory;
	    topic_ = (Topic)destination;
	    connection_ = factory.createTopicConnection();
	    session_ = connection_.createTopicSession(
		false,
		Session.AUTO_ACKNOWLEDGE
	    );
	} catch (JMSException e) {
	    _release();
	    throw (e);
	}
    }

    private void _release() {
	try {
	    if (publisher_ != null) {
		publisher_.close();
	    }
	} catch (JMSException e) {
	}
	try {
	    if (subscriber_ != null) {
		subscriber_.close();
	    }
	} catch (JMSException e) {
	}
	try {
	    if (session_ != null) {
		session_.close();
	    }
	} catch (JMSException e) {
	}
	try {
	    if (connection_ != null) {
		connection_.close();
	    }
	} catch (JMSException e) {
	}
	factory_ = null;
	topic_ = null;
	connection_ = null;
	session_ = null;
	publisher_ = null;
	subscriber_ = null;
    }

    public Message read() throws JMSException {
	if (subscriber_ == null) {
	    subscriber_ = session_.createSubscriber(topic_);
	}
	return (subscriber_.receiveNoWait());
    }

    public void write(Message message) throws JMSException {
	if (publisher_ == null) {
	    publisher_ = session_.createPublisher(topic_);
	}
	publisher_.publish(message);
    }

    public TextMessage createTextMessage() throws JMSException {
	return (session_.createTextMessage());
    }

    public ITabular getTableOfContents() throws JMSException {
	throw (new JMSException("topic does not access list of contents"));
    }

    protected Session _getSession() {
	return (session_);
    }
}
