/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.parcel;

import java.net.URL;
import java.io.OutputStream;
import java.io.IOException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import com.AsamiOffice.io.UIO;
import com.AsamiOffice.text.UString;
import com.AsamiOffice.xml.UXML;

/**
 * LinkGadget
 *
 * @since   Aug. 31, 2000
 * @version Feb. 25, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class LinkGadget extends AbstractGadget {
    private URL url_;
    private String baseURI_;

    public LinkGadget(URL url) {
	url_ = url;
    }

    public void setBaseURI(String uri) {
	baseURI_ = uri;
    }

    public void write(OutputStream out) throws IOException {
	UIO.concatStreams(url_.openStream(), out);
    }

    public byte[] getBytes() throws IOException {
	return (UIO.URL2Bytes(url_));
    }


    public boolean isText() {
	String uri = url_.toExternalForm();
	if (UString.isSuffix(
	    uri,
	    new String[] { "txt", "csv", "xml" }
	)) {
	    return (true);
	}
	return (false);
    }

    public String getText() throws IOException {
	return (UIO.URL2String(url_, getEncoding()));
    }

    public boolean isDocument() {
	String uri = url_.toExternalForm();
	if (UString.isSuffix(
	    uri,
	    new String[] { "xml" }
	)) {
	    return (true);
	}
	try {
	    if (UXML.hasXMLDeclaration(url_)) {
		return (true);
	    }
	} catch (IOException e) {
	}
	return (false);
    }

    public Document getDocument() throws IOException, SAXException {
//	DcumentBuilder builder = RBus.getDOMParser();
//	return (builder.parse(url_));
	throw (new UnsupportedOperationException());
    }
}
