/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2003  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.runtime;

import java.util.*;
import java.io.Writer;
import java.io.IOException;

/**
 * IRComponentLogFormatter
 *
 * @since   Jan. 19, 2003
 * @version Jan. 19, 2003
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public interface IRComponentLogFormatter extends IRComponentAtom {
    void setup(Properties properties);
    void log(
	String message,
	Writer writer
    ) throws IOException;
    void logEnter(
	Object object,
	String method,
	Writer writer
    ) throws IOException;
    void logEnter(
	Object object,
	String method,
	String arg,
	Writer writer
    ) throws IOException;
    void logEnter(
	Object object,
	String method,
	String arg1,
	String arg2,
	Writer writer
    ) throws IOException;
    void logEnter(
	Object object,
	String method,
	String arg1,
	String arg2,
	String arg3,
	Writer writer
    ) throws IOException;
    void logEnter(
	Object object,
	String name,
	String[] args,
	Writer writer
    ) throws IOException;
    void logLeave(
	Object object,
	String name,
	Writer writer
    ) throws IOException;
    void logLeave(
	Object object,
	String name,
	String result,
	Writer writer
    ) throws IOException;
    void logLeave(
	Object object,
	String name,
	Exception e,
	Writer writer
    ) throws IOException;
}
