/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2003  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.runtime.logger;

import java.util.*;
import java.io.*;
import org.relaxer.runtime.*;
import org.relaxer.runtime.datatype.RDateTime;

/**
 * PlainLogFormatter
 *
 * @since   Jan. 19, 2003
 * @version Jan. 19, 2003
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class PlainLogFormatter extends AbstractLogFormatter {
    public void log(
	String message,
	Writer writer
    ) throws IOException {
	_printTime(writer);
	writer.write(message);
	_printNewline(writer);
	writer.flush();
    }

    public void logEnter(
	Object object,
	String method,
	Writer writer
    ) throws IOException {
	_printTime(writer);
	_printClassMethod(object, method, writer);
	writer.write("()");
	_printNewline(writer);
	writer.flush();
    }

    public void logEnter(
	Object object,
	String method,
	String arg,
	Writer writer
    ) throws IOException {
	_printTime(writer);
	_printClassMethod(object, method, writer);
	writer.write("(");
	writer.write(arg);
	writer.write(")");
	_printNewline(writer);
	writer.flush();
    }

    public void logEnter(
	Object object,
	String method,
	String arg1,
	String arg2,
	Writer writer
    ) throws IOException {
	_printTime(writer);
	_printClassMethod(object, method, writer);
	writer.write("(");
	writer.write(arg1);
	writer.write(", ");
	writer.write(arg2);
	writer.write(")");
	_printNewline(writer);
	writer.flush();
    }

    public void logEnter(
	Object object,
	String method,
	String arg1,
	String arg2,
	String arg3,
	Writer writer
    ) throws IOException {
	_printTime(writer);
	_printClassMethod(object, method, writer);
	writer.write("(");
	writer.write(arg1);
	writer.write(", ");
	writer.write(arg2);
	writer.write(", ");
	writer.write(arg3);
	writer.write(")");
	_printNewline(writer);
	writer.flush();
    }

    public void logEnter(
	Object object,
	String method,
	String[] args,
	Writer writer
    ) throws IOException {
	_printTime(writer);
	_printClassMethod(object, method, writer);
	writer.write("(");
	if (args.length > 0) {
	    writer.write(args[0]);
	    for (int i = 1;i < args.length;i++) {
		writer.write(", ");
		writer.write(args[i]);
	    }
	}
    }

    public void logLeave(
	Object object,
	String method,
	Writer writer
    ) throws IOException {
	_printTime(writer);
	_printClassMethod(object, method, writer);
	writer.write("-->void");
	_printNewline(writer);
	writer.flush();
    }

    public void logLeave(
	Object object,
	String method,
	String result,
	Writer writer
    ) throws IOException {
	_printTime(writer);
	_printClassMethod(object, method, writer);
	writer.write("-->");
	writer.write(result);
	_printNewline(writer);
	writer.flush();
    }

    public void logLeave(
	Object object,
	String method,
	Exception e,
	Writer writer
    ) throws IOException {
	_printTime(writer);
	_printClassMethod(object, method, writer);
	writer.write("-->");
	writer.write(e.getMessage());
	_printNewline(writer);
	writer.flush();
    }

    private void _printClassMethod(
	Object object,
	String method,
	Writer writer
    ) throws IOException {
	writer.write(object.getClass().getName());
	writer.write(".");
	writer.write(method);
    }

    private void _printTime(Writer writer) throws IOException {
	writer.write(new RDateTime().toString());
	writer.write(" ");
    }

    private void _printNewline(Writer wtier) throws IOException {
	wtier.write('\n');
    }
}
