package org.relaxer.runtime.rFactory;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FComponent</b> is generated by Relaxer based on factory.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="component">
 *   <element name="id">
 *     <data type="token"/>
 *   </element>
 *   <choice>
 *     <element name="beans">
 *       <ref name="componentClient"/>
 *       <optional>
 *         <ref name="componentProvider"/>
 *       </optional>
 *     </element>
 *     <element name="rmi">
 *       <element name="name">
 *         <data type="token"/>
 *       </element>
 *       <optional>
 *         <ref name="componentClient"/>
 *       </optional>
 *       <optional>
 *         <ref name="componentServer"/>
 *       </optional>
 *       <optional>
 *         <ref name="componentProvider"/>
 *       </optional>
 *     </element>
 *     <element name="iiop">
 *       <element name="name">
 *         <data type="token"/>
 *       </element>
 *       <optional>
 *         <ref name="componentClient"/>
 *       </optional>
 *       <optional>
 *         <ref name="componentServer"/>
 *       </optional>
 *       <optional>
 *         <ref name="componentProvider"/>
 *       </optional>
 *     </element>
 *     <element name="ejb">
 *       <element name="uri">
 *         <data type="token"/>
 *       </element>
 *       <optional>
 *         <ref name="componentClient"/>
 *       </optional>
 *       <optional>
 *         <ref name="componentServer"/>
 *       </optional>
 *       <optional>
 *         <ref name="componentProvider"/>
 *       </optional>
 *     </element>
 *     <element name="asoap"/>
 *     <element name="jaxm"/>
 *   </choice>
 *   <zeroOrMore>
 *     <ref name="envEntry"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="component"&gt;
 *   &lt;element name="id"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/element&gt;
 *   &lt;choice&gt;
 *     &lt;element name="beans"&gt;
 *       &lt;ref name="componentClient"/&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentProvider"/&gt;
 *       &lt;/optional&gt;
 *     &lt;/element&gt;
 *     &lt;element name="rmi"&gt;
 *       &lt;element name="name"&gt;
 *         &lt;data type="token"/&gt;
 *       &lt;/element&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentClient"/&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentServer"/&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentProvider"/&gt;
 *       &lt;/optional&gt;
 *     &lt;/element&gt;
 *     &lt;element name="iiop"&gt;
 *       &lt;element name="name"&gt;
 *         &lt;data type="token"/&gt;
 *       &lt;/element&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentClient"/&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentServer"/&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentProvider"/&gt;
 *       &lt;/optional&gt;
 *     &lt;/element&gt;
 *     &lt;element name="ejb"&gt;
 *       &lt;element name="uri"&gt;
 *         &lt;data type="token"/&gt;
 *       &lt;/element&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentClient"/&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentServer"/&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;ref name="componentProvider"/&gt;
 *       &lt;/optional&gt;
 *     &lt;/element&gt;
 *     &lt;element name="asoap"/&gt;
 *     &lt;element name="jaxm"/&gt;
 *   &lt;/choice&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="envEntry"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version factory.rng (Thu Sep 05 12:38:32 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class FComponent implements java.io.Serializable {
    private String id_;
    private IFComponentChoice content_;
    // List<FEnvEntry>
    private java.util.List envEntry_ = new java.util.ArrayList();

    /**
     * Creates a <code>FComponent</code>.
     *
     */
    public FComponent() {
    }

    /**
     * Creates a <code>FComponent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FComponent(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FComponent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FComponent(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FComponent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FComponent(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FComponent</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponent(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FComponent</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponent(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FComponent</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponent(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FComponent</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponent(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FComponent</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponent(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FComponent</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponent(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FComponent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FComponent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FComponent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        id_ = URelaxer.getElementPropertyAsString(stack.popElement());
        if (FComponentRmi.isMatch(stack)) {
            setContent(new FComponentRmi(stack));
        } else if (FComponentIiop.isMatch(stack)) {
            setContent(new FComponentIiop(stack));
        } else if (FComponentEjb.isMatch(stack)) {
            setContent(new FComponentEjb(stack));
        } else if (FComponentBeans.isMatch(stack)) {
            setContent(new FComponentBeans(stack));
        } else if (FComponentAsoap.isMatch(stack)) {
            setContent(new FComponentAsoap(stack));
        } else if (FComponentJaxm.isMatch(stack)) {
            setContent(new FComponentJaxm(stack));
        } else {
            throw (new IllegalArgumentException());
        }
        envEntry_.clear();
        while (!stack.isEmptyElement()) {
            if (FEnvEntry.isMatch(stack)) {
                addEnvEntry(new FEnvEntry(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("component");
        int size;
        URelaxer.setElementPropertyByString(element, "id", this.id_);
        this.content_.makeElement(element);
        size = this.envEntry_.size();
        for (int i = 0;i < size;i++) {
            FEnvEntry value = (FEnvEntry)this.envEntry_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FComponent</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FComponent</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponent</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponent</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponent</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponent</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public final String getId() {
        return (id_);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public final void setId(String id) {
        this.id_ = id;
    }

    /**
     * Gets the IFComponentChoice property <b>content</b>.
     *
     * @return IFComponentChoice
     */
    public final IFComponentChoice getContent() {
        return (content_);
    }

    /**
     * Sets the IFComponentChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IFComponentChoice content) {
        this.content_ = content;
    }

    /**
     * Gets the FEnvEntry property <b>envEntry</b>.
     *
     * @return FEnvEntry[]
     */
    public final FEnvEntry[] getEnvEntry() {
        FEnvEntry[] array = new FEnvEntry[envEntry_.size()];
        return ((FEnvEntry[])envEntry_.toArray(array));
    }

    /**
     * Sets the FEnvEntry property <b>envEntry</b>.
     *
     * @param envEntry
     */
    public final void setEnvEntry(FEnvEntry[] envEntry) {
        this.envEntry_.clear();
        for (int i = 0;i < envEntry.length;i++) {
            addEnvEntry(envEntry[i]);
        }
    }

    /**
     * Sets the FEnvEntry property <b>envEntry</b>.
     *
     * @param envEntry
     */
    public final void setEnvEntry(FEnvEntry envEntry) {
        this.envEntry_.clear();
        addEnvEntry(envEntry);
    }

    /**
     * Adds the FEnvEntry property <b>envEntry</b>.
     *
     * @param envEntry
     */
    public final void addEnvEntry(FEnvEntry envEntry) {
        this.envEntry_.add(envEntry);
    }

    /**
     * Gets number of the FEnvEntry property <b>envEntry</b>.
     *
     * @return int
     */
    public final int getEnvEntryCount() {
        return (envEntry_.size());
    }

    /**
     * Gets the FEnvEntry property <b>envEntry</b> by index.
     *
     * @param index
     * @return FEnvEntry
     */
    public final FEnvEntry getEnvEntry(int index) {
        return ((FEnvEntry)envEntry_.get(index));
    }

    /**
     * Sets the FEnvEntry property <b>envEntry</b> by index.
     *
     * @param index
     * @param envEntry
     */
    public final void setEnvEntry(int index, FEnvEntry envEntry) {
        this.envEntry_.set(index, envEntry);
    }

    /**
     * Adds the FEnvEntry property <b>envEntry</b> by index.
     *
     * @param index
     * @param envEntry
     */
    public final void addEnvEntry(int index, FEnvEntry envEntry) {
        this.envEntry_.add(index, envEntry);
    }

    /**
     * Remove the FEnvEntry property <b>envEntry</b> by index.
     *
     * @param index
     */
    public final void removeEnvEntry(int index) {
        this.envEntry_.remove(index);
    }

    /**
     * Remove the FEnvEntry property <b>envEntry</b> by object.
     *
     * @param envEntry
     */
    public final void removeEnvEntry(FEnvEntry envEntry) {
        this.envEntry_.remove(envEntry);
    }

    /**
     * Clear the FEnvEntry property <b>envEntry</b>.
     *
     */
    public final void clearEnvEntry() {
        this.envEntry_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<component");
        buffer.append(">");
        buffer.append("<id>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(getId())));
        buffer.append("</id>");
        content_.makeTextElement(buffer);
        size = this.envEntry_.size();
        for (int i = 0;i < size;i++) {
            FEnvEntry value = (FEnvEntry)this.envEntry_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</component>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<component");
        buffer.print(">");
        buffer.print("<id>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(getId())));
        buffer.print("</id>");
        content_.makeTextElement(buffer);
        size = this.envEntry_.size();
        for (int i = 0;i < size;i++) {
            FEnvEntry value = (FEnvEntry)this.envEntry_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</component>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FComponent</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "component")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "id")) {
            return (false);
        }
        $match$ = true;
        if (FComponentRmi.isMatchHungry(target)) {
            $match$ = true;
        } else if (FComponentIiop.isMatchHungry(target)) {
            $match$ = true;
        } else if (FComponentEjb.isMatchHungry(target)) {
            $match$ = true;
        } else if (FComponentBeans.isMatchHungry(target)) {
            $match$ = true;
        } else if (FComponentAsoap.isMatchHungry(target)) {
            $match$ = true;
        } else if (FComponentJaxm.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        while (!target.isEmptyElement()) {
            if (!FEnvEntry.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FComponent</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FComponent</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
