package org.relaxer.runtime.rFactory;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FConfig</b> is generated by Relaxer based on factory.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="config">
 *   <zeroOrMore>
 *     <ref name="log"/>
 *   </zeroOrMore>
 *   <optional>
 *     <ref name="factory"/>
 *   </optional>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="config"&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="log"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;optional&gt;
 *     &lt;ref name="factory"/&gt;
 *   &lt;/optional&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version factory.rng (Thu Sep 05 12:38:32 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class FConfig implements java.io.Serializable {
    // List<FLog>
    private java.util.List log_ = new java.util.ArrayList();
    private FFactory factory_;

    /**
     * Creates a <code>FConfig</code>.
     *
     */
    public FConfig() {
    }

    /**
     * Creates a <code>FConfig</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FConfig(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FConfig</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FConfig(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FConfig</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FConfig(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FConfig</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FConfig(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FConfig</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FConfig(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FConfig</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FConfig(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FConfig</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FConfig(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FConfig</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FConfig(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FConfig</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FConfig(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FConfig</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FConfig</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FConfig</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        log_.clear();
        while (!stack.isEmptyElement()) {
            if (FLog.isMatch(stack)) {
                addLog(new FLog(stack));
            } else {
                break;
            }
        }
        if (FFactory.isMatch(stack)) {
            setFactory(new FFactory(stack));
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("config");
        int size;
        size = this.log_.size();
        for (int i = 0;i < size;i++) {
            FLog value = (FLog)this.log_.get(i);
            value.makeElement(element);
        }
        if (this.factory_ != null) {
            this.factory_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FConfig</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FConfig</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FConfig</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FConfig</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FConfig</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FConfig</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the FLog property <b>log</b>.
     *
     * @return FLog[]
     */
    public final FLog[] getLog() {
        FLog[] array = new FLog[log_.size()];
        return ((FLog[])log_.toArray(array));
    }

    /**
     * Sets the FLog property <b>log</b>.
     *
     * @param log
     */
    public final void setLog(FLog[] log) {
        this.log_.clear();
        for (int i = 0;i < log.length;i++) {
            addLog(log[i]);
        }
    }

    /**
     * Sets the FLog property <b>log</b>.
     *
     * @param log
     */
    public final void setLog(FLog log) {
        this.log_.clear();
        addLog(log);
    }

    /**
     * Adds the FLog property <b>log</b>.
     *
     * @param log
     */
    public final void addLog(FLog log) {
        this.log_.add(log);
    }

    /**
     * Gets number of the FLog property <b>log</b>.
     *
     * @return int
     */
    public final int getLogCount() {
        return (log_.size());
    }

    /**
     * Gets the FLog property <b>log</b> by index.
     *
     * @param index
     * @return FLog
     */
    public final FLog getLog(int index) {
        return ((FLog)log_.get(index));
    }

    /**
     * Sets the FLog property <b>log</b> by index.
     *
     * @param index
     * @param log
     */
    public final void setLog(int index, FLog log) {
        this.log_.set(index, log);
    }

    /**
     * Adds the FLog property <b>log</b> by index.
     *
     * @param index
     * @param log
     */
    public final void addLog(int index, FLog log) {
        this.log_.add(index, log);
    }

    /**
     * Remove the FLog property <b>log</b> by index.
     *
     * @param index
     */
    public final void removeLog(int index) {
        this.log_.remove(index);
    }

    /**
     * Remove the FLog property <b>log</b> by object.
     *
     * @param log
     */
    public final void removeLog(FLog log) {
        this.log_.remove(log);
    }

    /**
     * Clear the FLog property <b>log</b>.
     *
     */
    public final void clearLog() {
        this.log_.clear();
    }

    /**
     * Gets the FFactory property <b>factory</b>.
     *
     * @return FFactory
     */
    public final FFactory getFactory() {
        return (factory_);
    }

    /**
     * Sets the FFactory property <b>factory</b>.
     *
     * @param factory
     */
    public final void setFactory(FFactory factory) {
        this.factory_ = factory;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<config");
        buffer.append(">");
        size = this.log_.size();
        for (int i = 0;i < size;i++) {
            FLog value = (FLog)this.log_.get(i);
            value.makeTextElement(buffer);
        }
        if (factory_ != null) {
            factory_.makeTextElement(buffer);
        }
        buffer.append("</config>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<config");
        buffer.print(">");
        size = this.log_.size();
        for (int i = 0;i < size;i++) {
            FLog value = (FLog)this.log_.get(i);
            value.makeTextElement(buffer);
        }
        if (factory_ != null) {
            factory_.makeTextElement(buffer);
        }
        buffer.print("</config>");
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FConfig</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "config")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (!target.isEmptyElement()) {
            if (!FLog.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (FFactory.isMatchHungry(target)) {
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FConfig</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FConfig</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
