package org.relaxer.runtime.rFactory;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FFactory</b> is generated by Relaxer based on factory.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="factory">
 *   <zeroOrMore>
 *     <ref name="component"/>
 *   </zeroOrMore>
 *   <zeroOrMore>
 *     <ref name="dao"/>
 *   </zeroOrMore>
 *   <zeroOrMore>
 *     <ref name="ejb"/>
 *   </zeroOrMore>
 *   <zeroOrMore>
 *     <ref name="jdbc"/>
 *   </zeroOrMore>
 *   <zeroOrMore>
 *     <ref name="jms"/>
 *   </zeroOrMore>
 *   <optional>
 *     <ref name="auth"/>
 *   </optional>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="factory"&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="component"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="dao"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="ejb"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="jdbc"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="jms"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;optional&gt;
 *     &lt;ref name="auth"/&gt;
 *   &lt;/optional&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version factory.rng (Thu Sep 05 12:38:32 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class FFactory implements java.io.Serializable {
    // List<FComponent>
    private java.util.List component_ = new java.util.ArrayList();
    // List<FDao>
    private java.util.List dao_ = new java.util.ArrayList();
    // List<FEjb>
    private java.util.List ejb_ = new java.util.ArrayList();
    // List<FJdbc>
    private java.util.List jdbc_ = new java.util.ArrayList();
    // List<FJms>
    private java.util.List jms_ = new java.util.ArrayList();
    private FAuth auth_;

    /**
     * Creates a <code>FFactory</code>.
     *
     */
    public FFactory() {
    }

    /**
     * Creates a <code>FFactory</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FFactory(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FFactory</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FFactory(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FFactory</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FFactory(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FFactory</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FFactory(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FFactory</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FFactory(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FFactory</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FFactory(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FFactory</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FFactory(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FFactory</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FFactory(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FFactory</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FFactory(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FFactory</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FFactory</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FFactory</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        component_.clear();
        while (!stack.isEmptyElement()) {
            if (FComponent.isMatch(stack)) {
                addComponent(new FComponent(stack));
            } else {
                break;
            }
        }
        dao_.clear();
        while (!stack.isEmptyElement()) {
            if (FDao.isMatch(stack)) {
                addDao(new FDao(stack));
            } else {
                break;
            }
        }
        ejb_.clear();
        while (!stack.isEmptyElement()) {
            if (FEjb.isMatch(stack)) {
                addEjb(new FEjb(stack));
            } else {
                break;
            }
        }
        jdbc_.clear();
        while (!stack.isEmptyElement()) {
            if (FJdbc.isMatch(stack)) {
                addJdbc(new FJdbc(stack));
            } else {
                break;
            }
        }
        jms_.clear();
        while (!stack.isEmptyElement()) {
            if (FJms.isMatch(stack)) {
                addJms(new FJms(stack));
            } else {
                break;
            }
        }
        if (FAuth.isMatch(stack)) {
            setAuth(new FAuth(stack));
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("factory");
        int size;
        size = this.component_.size();
        for (int i = 0;i < size;i++) {
            FComponent value = (FComponent)this.component_.get(i);
            value.makeElement(element);
        }
        size = this.dao_.size();
        for (int i = 0;i < size;i++) {
            FDao value = (FDao)this.dao_.get(i);
            value.makeElement(element);
        }
        size = this.ejb_.size();
        for (int i = 0;i < size;i++) {
            FEjb value = (FEjb)this.ejb_.get(i);
            value.makeElement(element);
        }
        size = this.jdbc_.size();
        for (int i = 0;i < size;i++) {
            FJdbc value = (FJdbc)this.jdbc_.get(i);
            value.makeElement(element);
        }
        size = this.jms_.size();
        for (int i = 0;i < size;i++) {
            FJms value = (FJms)this.jms_.get(i);
            value.makeElement(element);
        }
        if (this.auth_ != null) {
            this.auth_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FFactory</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FFactory</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FFactory</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FFactory</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FFactory</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FFactory</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the FComponent property <b>component</b>.
     *
     * @return FComponent[]
     */
    public final FComponent[] getComponent() {
        FComponent[] array = new FComponent[component_.size()];
        return ((FComponent[])component_.toArray(array));
    }

    /**
     * Sets the FComponent property <b>component</b>.
     *
     * @param component
     */
    public final void setComponent(FComponent[] component) {
        this.component_.clear();
        for (int i = 0;i < component.length;i++) {
            addComponent(component[i]);
        }
    }

    /**
     * Sets the FComponent property <b>component</b>.
     *
     * @param component
     */
    public final void setComponent(FComponent component) {
        this.component_.clear();
        addComponent(component);
    }

    /**
     * Adds the FComponent property <b>component</b>.
     *
     * @param component
     */
    public final void addComponent(FComponent component) {
        this.component_.add(component);
    }

    /**
     * Gets number of the FComponent property <b>component</b>.
     *
     * @return int
     */
    public final int getComponentCount() {
        return (component_.size());
    }

    /**
     * Gets the FComponent property <b>component</b> by index.
     *
     * @param index
     * @return FComponent
     */
    public final FComponent getComponent(int index) {
        return ((FComponent)component_.get(index));
    }

    /**
     * Sets the FComponent property <b>component</b> by index.
     *
     * @param index
     * @param component
     */
    public final void setComponent(int index, FComponent component) {
        this.component_.set(index, component);
    }

    /**
     * Adds the FComponent property <b>component</b> by index.
     *
     * @param index
     * @param component
     */
    public final void addComponent(int index, FComponent component) {
        this.component_.add(index, component);
    }

    /**
     * Remove the FComponent property <b>component</b> by index.
     *
     * @param index
     */
    public final void removeComponent(int index) {
        this.component_.remove(index);
    }

    /**
     * Remove the FComponent property <b>component</b> by object.
     *
     * @param component
     */
    public final void removeComponent(FComponent component) {
        this.component_.remove(component);
    }

    /**
     * Clear the FComponent property <b>component</b>.
     *
     */
    public final void clearComponent() {
        this.component_.clear();
    }

    /**
     * Gets the FDao property <b>dao</b>.
     *
     * @return FDao[]
     */
    public final FDao[] getDao() {
        FDao[] array = new FDao[dao_.size()];
        return ((FDao[])dao_.toArray(array));
    }

    /**
     * Sets the FDao property <b>dao</b>.
     *
     * @param dao
     */
    public final void setDao(FDao[] dao) {
        this.dao_.clear();
        for (int i = 0;i < dao.length;i++) {
            addDao(dao[i]);
        }
    }

    /**
     * Sets the FDao property <b>dao</b>.
     *
     * @param dao
     */
    public final void setDao(FDao dao) {
        this.dao_.clear();
        addDao(dao);
    }

    /**
     * Adds the FDao property <b>dao</b>.
     *
     * @param dao
     */
    public final void addDao(FDao dao) {
        this.dao_.add(dao);
    }

    /**
     * Gets number of the FDao property <b>dao</b>.
     *
     * @return int
     */
    public final int getDaoCount() {
        return (dao_.size());
    }

    /**
     * Gets the FDao property <b>dao</b> by index.
     *
     * @param index
     * @return FDao
     */
    public final FDao getDao(int index) {
        return ((FDao)dao_.get(index));
    }

    /**
     * Sets the FDao property <b>dao</b> by index.
     *
     * @param index
     * @param dao
     */
    public final void setDao(int index, FDao dao) {
        this.dao_.set(index, dao);
    }

    /**
     * Adds the FDao property <b>dao</b> by index.
     *
     * @param index
     * @param dao
     */
    public final void addDao(int index, FDao dao) {
        this.dao_.add(index, dao);
    }

    /**
     * Remove the FDao property <b>dao</b> by index.
     *
     * @param index
     */
    public final void removeDao(int index) {
        this.dao_.remove(index);
    }

    /**
     * Remove the FDao property <b>dao</b> by object.
     *
     * @param dao
     */
    public final void removeDao(FDao dao) {
        this.dao_.remove(dao);
    }

    /**
     * Clear the FDao property <b>dao</b>.
     *
     */
    public final void clearDao() {
        this.dao_.clear();
    }

    /**
     * Gets the FEjb property <b>ejb</b>.
     *
     * @return FEjb[]
     */
    public final FEjb[] getEjb() {
        FEjb[] array = new FEjb[ejb_.size()];
        return ((FEjb[])ejb_.toArray(array));
    }

    /**
     * Sets the FEjb property <b>ejb</b>.
     *
     * @param ejb
     */
    public final void setEjb(FEjb[] ejb) {
        this.ejb_.clear();
        for (int i = 0;i < ejb.length;i++) {
            addEjb(ejb[i]);
        }
    }

    /**
     * Sets the FEjb property <b>ejb</b>.
     *
     * @param ejb
     */
    public final void setEjb(FEjb ejb) {
        this.ejb_.clear();
        addEjb(ejb);
    }

    /**
     * Adds the FEjb property <b>ejb</b>.
     *
     * @param ejb
     */
    public final void addEjb(FEjb ejb) {
        this.ejb_.add(ejb);
    }

    /**
     * Gets number of the FEjb property <b>ejb</b>.
     *
     * @return int
     */
    public final int getEjbCount() {
        return (ejb_.size());
    }

    /**
     * Gets the FEjb property <b>ejb</b> by index.
     *
     * @param index
     * @return FEjb
     */
    public final FEjb getEjb(int index) {
        return ((FEjb)ejb_.get(index));
    }

    /**
     * Sets the FEjb property <b>ejb</b> by index.
     *
     * @param index
     * @param ejb
     */
    public final void setEjb(int index, FEjb ejb) {
        this.ejb_.set(index, ejb);
    }

    /**
     * Adds the FEjb property <b>ejb</b> by index.
     *
     * @param index
     * @param ejb
     */
    public final void addEjb(int index, FEjb ejb) {
        this.ejb_.add(index, ejb);
    }

    /**
     * Remove the FEjb property <b>ejb</b> by index.
     *
     * @param index
     */
    public final void removeEjb(int index) {
        this.ejb_.remove(index);
    }

    /**
     * Remove the FEjb property <b>ejb</b> by object.
     *
     * @param ejb
     */
    public final void removeEjb(FEjb ejb) {
        this.ejb_.remove(ejb);
    }

    /**
     * Clear the FEjb property <b>ejb</b>.
     *
     */
    public final void clearEjb() {
        this.ejb_.clear();
    }

    /**
     * Gets the FJdbc property <b>jdbc</b>.
     *
     * @return FJdbc[]
     */
    public final FJdbc[] getJdbc() {
        FJdbc[] array = new FJdbc[jdbc_.size()];
        return ((FJdbc[])jdbc_.toArray(array));
    }

    /**
     * Sets the FJdbc property <b>jdbc</b>.
     *
     * @param jdbc
     */
    public final void setJdbc(FJdbc[] jdbc) {
        this.jdbc_.clear();
        for (int i = 0;i < jdbc.length;i++) {
            addJdbc(jdbc[i]);
        }
    }

    /**
     * Sets the FJdbc property <b>jdbc</b>.
     *
     * @param jdbc
     */
    public final void setJdbc(FJdbc jdbc) {
        this.jdbc_.clear();
        addJdbc(jdbc);
    }

    /**
     * Adds the FJdbc property <b>jdbc</b>.
     *
     * @param jdbc
     */
    public final void addJdbc(FJdbc jdbc) {
        this.jdbc_.add(jdbc);
    }

    /**
     * Gets number of the FJdbc property <b>jdbc</b>.
     *
     * @return int
     */
    public final int getJdbcCount() {
        return (jdbc_.size());
    }

    /**
     * Gets the FJdbc property <b>jdbc</b> by index.
     *
     * @param index
     * @return FJdbc
     */
    public final FJdbc getJdbc(int index) {
        return ((FJdbc)jdbc_.get(index));
    }

    /**
     * Sets the FJdbc property <b>jdbc</b> by index.
     *
     * @param index
     * @param jdbc
     */
    public final void setJdbc(int index, FJdbc jdbc) {
        this.jdbc_.set(index, jdbc);
    }

    /**
     * Adds the FJdbc property <b>jdbc</b> by index.
     *
     * @param index
     * @param jdbc
     */
    public final void addJdbc(int index, FJdbc jdbc) {
        this.jdbc_.add(index, jdbc);
    }

    /**
     * Remove the FJdbc property <b>jdbc</b> by index.
     *
     * @param index
     */
    public final void removeJdbc(int index) {
        this.jdbc_.remove(index);
    }

    /**
     * Remove the FJdbc property <b>jdbc</b> by object.
     *
     * @param jdbc
     */
    public final void removeJdbc(FJdbc jdbc) {
        this.jdbc_.remove(jdbc);
    }

    /**
     * Clear the FJdbc property <b>jdbc</b>.
     *
     */
    public final void clearJdbc() {
        this.jdbc_.clear();
    }

    /**
     * Gets the FJms property <b>jms</b>.
     *
     * @return FJms[]
     */
    public final FJms[] getJms() {
        FJms[] array = new FJms[jms_.size()];
        return ((FJms[])jms_.toArray(array));
    }

    /**
     * Sets the FJms property <b>jms</b>.
     *
     * @param jms
     */
    public final void setJms(FJms[] jms) {
        this.jms_.clear();
        for (int i = 0;i < jms.length;i++) {
            addJms(jms[i]);
        }
    }

    /**
     * Sets the FJms property <b>jms</b>.
     *
     * @param jms
     */
    public final void setJms(FJms jms) {
        this.jms_.clear();
        addJms(jms);
    }

    /**
     * Adds the FJms property <b>jms</b>.
     *
     * @param jms
     */
    public final void addJms(FJms jms) {
        this.jms_.add(jms);
    }

    /**
     * Gets number of the FJms property <b>jms</b>.
     *
     * @return int
     */
    public final int getJmsCount() {
        return (jms_.size());
    }

    /**
     * Gets the FJms property <b>jms</b> by index.
     *
     * @param index
     * @return FJms
     */
    public final FJms getJms(int index) {
        return ((FJms)jms_.get(index));
    }

    /**
     * Sets the FJms property <b>jms</b> by index.
     *
     * @param index
     * @param jms
     */
    public final void setJms(int index, FJms jms) {
        this.jms_.set(index, jms);
    }

    /**
     * Adds the FJms property <b>jms</b> by index.
     *
     * @param index
     * @param jms
     */
    public final void addJms(int index, FJms jms) {
        this.jms_.add(index, jms);
    }

    /**
     * Remove the FJms property <b>jms</b> by index.
     *
     * @param index
     */
    public final void removeJms(int index) {
        this.jms_.remove(index);
    }

    /**
     * Remove the FJms property <b>jms</b> by object.
     *
     * @param jms
     */
    public final void removeJms(FJms jms) {
        this.jms_.remove(jms);
    }

    /**
     * Clear the FJms property <b>jms</b>.
     *
     */
    public final void clearJms() {
        this.jms_.clear();
    }

    /**
     * Gets the FAuth property <b>auth</b>.
     *
     * @return FAuth
     */
    public final FAuth getAuth() {
        return (auth_);
    }

    /**
     * Sets the FAuth property <b>auth</b>.
     *
     * @param auth
     */
    public final void setAuth(FAuth auth) {
        this.auth_ = auth;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<factory");
        buffer.append(">");
        size = this.component_.size();
        for (int i = 0;i < size;i++) {
            FComponent value = (FComponent)this.component_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.dao_.size();
        for (int i = 0;i < size;i++) {
            FDao value = (FDao)this.dao_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.ejb_.size();
        for (int i = 0;i < size;i++) {
            FEjb value = (FEjb)this.ejb_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.jdbc_.size();
        for (int i = 0;i < size;i++) {
            FJdbc value = (FJdbc)this.jdbc_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.jms_.size();
        for (int i = 0;i < size;i++) {
            FJms value = (FJms)this.jms_.get(i);
            value.makeTextElement(buffer);
        }
        if (auth_ != null) {
            auth_.makeTextElement(buffer);
        }
        buffer.append("</factory>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<factory");
        buffer.print(">");
        size = this.component_.size();
        for (int i = 0;i < size;i++) {
            FComponent value = (FComponent)this.component_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.dao_.size();
        for (int i = 0;i < size;i++) {
            FDao value = (FDao)this.dao_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.ejb_.size();
        for (int i = 0;i < size;i++) {
            FEjb value = (FEjb)this.ejb_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.jdbc_.size();
        for (int i = 0;i < size;i++) {
            FJdbc value = (FJdbc)this.jdbc_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.jms_.size();
        for (int i = 0;i < size;i++) {
            FJms value = (FJms)this.jms_.get(i);
            value.makeTextElement(buffer);
        }
        if (auth_ != null) {
            auth_.makeTextElement(buffer);
        }
        buffer.print("</factory>");
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FFactory</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "factory")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (!target.isEmptyElement()) {
            if (!FComponent.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        while (!target.isEmptyElement()) {
            if (!FDao.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        while (!target.isEmptyElement()) {
            if (!FEjb.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        while (!target.isEmptyElement()) {
            if (!FJdbc.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        while (!target.isEmptyElement()) {
            if (!FJms.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (FAuth.isMatchHungry(target)) {
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FFactory</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FFactory</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
