/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import javax.xml.parsers.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * AbstractTabular
 *
 * @since   Jul. 11, 2001
 * @version Aug. 20, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */

public abstract class AbstractTabular implements ITabular {
    private String name_;
    private boolean namespaceAware_ = false;

    protected final void _setName(String name) {
	name_ = name;
    }

    public final String getName() {
	return (name_);
    }

    public final void setNamespaceAware(boolean aware) {
	namespaceAware_ = aware;
    }

    public final boolean isNamespaceAware() {
	return (namespaceAware_);
    }

    public String getLabel(int x) {
	return (Integer.toString(x + 1));
    }

    public Document getDocument() throws ParserConfigurationException {
	DocumentBuilderFactory factory
	    = DocumentBuilderFactory.newInstance();
	DocumentBuilder builder = factory.newDocumentBuilder();
	Document doc = builder.newDocument();
	Element table = getElement(doc);
	doc.appendChild(table);
	return (doc);
    }

    public Element getElement(Document doc) {
	if (namespaceAware_) {
	    return (_getElementNS(doc));
	} else {
	    return (_getElement(doc));
	}
    }

    private Element _getElement(Document doc) {
	Element table = doc.createElement("table");
	_makeTHead(table);
	_makeTBody(table);
	return (table);
    }

    private void _makeTHead(Element table) {
	int width = getWidth();
	Document doc = table.getOwnerDocument();
	Element thead = doc.createElement("thead");
	Element tr = doc.createElement("tr");
	for (int x = 0;x < width;x++) {
	    Element th = doc.createElement("th");
	    String data = _makeData(getLabel(x));
	    th.appendChild(doc.createTextNode(data));
	    tr.appendChild(th);
	}
	thead.appendChild(tr);
	table.appendChild(thead);
    }

    private void _makeTBody(Element table) {
	int width = getWidth();
	int height = getHeight();
	Document doc = table.getOwnerDocument();
	Element tbody = doc.createElement("tbody");
	for (int y = 0;y < height;y++) {
	    Element tr = doc.createElement("tr");
	    for (int x = 0;x < width;x++) {
		String data = _makeData(get(x, y));
		Element td = doc.createElement("td");
		td.appendChild(doc.createTextNode(data));
		tr.appendChild(td);
	    }
	    tbody.appendChild(tr);
	}
	table.appendChild(tbody);
    }

    private Element _getElementNS(Document doc) {
	Element table = doc.createElementNS(XHTML_NS, "table");
	_makeTHeadNS(table);
	_makeTBodyNS(table);
	return (table);
    }

    private void _makeTHeadNS(Element table) {
	int width = getWidth();
	Document doc = table.getOwnerDocument();
	Element thead = doc.createElementNS(XHTML_NS, "thead");
	Element tr = doc.createElementNS(XHTML_NS, "tr");
	for (int x = 0;x < width;x++) {
	    Element th = doc.createElementNS(XHTML_NS, "th");
	    String data = _makeData(getLabel(x));
	    th.appendChild(doc.createTextNode(data));
	    tr.appendChild(th);
	}
	thead.appendChild(tr);
	table.appendChild(thead);
    }

    private void _makeTBodyNS(Element table) {
	int width = getWidth();
	int height = getHeight();
	Document doc = table.getOwnerDocument();
	Element tbody = doc.createElementNS(XHTML_NS, "tbody");
	for (int y = 0;y < height;y++) {
	    Element tr = doc.createElementNS(XHTML_NS, "tr");
	    for (int x = 0;x < width;x++) {
		String data = _makeData(get(x, y));
		Element td = doc.createElementNS(XHTML_NS, "td");
		td.appendChild(doc.createTextNode(data));
		tr.appendChild(td);
	    }
	    tbody.appendChild(tr);
	}
	table.appendChild(tbody);
    }

    private String _makeData(Object object) {
	if (object == null) {
	    return ("");
	} else {
	    return (object.toString());
	}
    }
}
