/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.util.Arrays;
import org.relaxer.util.D2Array;
import org.relaxer.util.D1Array;

/**
 * D2ArrayTabular
 *
 * @since   Jul. 11, 2001
 * @version Aug. 12, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class D2ArrayTabular extends AbstractMutableTabular {
    private D2Array array_;
    private D1Array labels_ = new D1Array();

    public D2ArrayTabular() {
    }

    public D2ArrayTabular(String[] labels) {
	_init(new D2Array(), labels);
    }

    public D2ArrayTabular(D2Array array) {
	_init(array, null);
    }

    public D2ArrayTabular(D2Array array, String[] labels) {
	_init(array, labels);
    }

    private void _init(D2Array array, String[] labels) {
	array_ = array;
	labels_.addAll(Arrays.asList(labels));
    }

    public int getWidth() {
	return (array_.getWidth());
    }

    public int getHeight() {
	return (array_.getHeight());
    }

    public String getLabel(int x) {
	if (labels_ != null) {
	    return ((String)labels_.get(x));
	} else {
	    return (super.getLabel(x));
	}
    }

    public void setLabel(int x, String label) {
	labels_.put(x, label);
    }

    public Object get(int x, int y) {
	return (array_.get(x, y));
    }

    public void set(int x, int y, Object data) {
	array_.put(x, y, data);
    }

    public void clearData() {
	array_ = new D2Array();
    }
}
