/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.io.IOException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
/*
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XPathProcessorImpl;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.apache.xalan.xpath.xml.PrefixResolverDefault;
*/
import org.relaxer.util.D2Array;
import org.relaxer.xml.UDOM;

/**
 * HTMLTableTabular
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class HTMLTableTabular extends TabularDecorator {
    public HTMLTableTabular(String uri) 
	throws ParserConfigurationException, SAXException, IOException {

	Element table = _findTableElement(uri);
	String[] labels = _table2Labels(table);
	D2Array data = _table2Array(table);
	_setup(new D2ArrayTabular(data, labels));
    }

    private Element _findTableElement(String uri)
	throws ParserConfigurationException, SAXException, IOException {

	String page = _getPage(uri);
	String path = _getPath(uri);
	Element root = _getDocumentRoot(page);
	if (path == null) {
	    return (root);
	}
	Element table = _getTable(root, path);
	return (table);
    }

    private String _getPage(String uri) {
	int index = uri.indexOf("#");
	if (index == -1) {
	    return (uri);
	}
	return (uri.substring(0, index));
    }

    private String _getPath(String uri) {
	int index = uri.indexOf("#");
	if (index == -1) {
	    return (null);
	}
	return (uri.substring(index + 1));
    }

    private Element _getDocumentRoot(String page)
	throws ParserConfigurationException, SAXException, IOException {

	DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	DocumentBuilder builder = factory.newDocumentBuilder();
	Document doc = builder.parse(page);
	return (doc.getDocumentElement());
    }

    private Element _getTable(Element root, String path) throws SAXException {
	throw (new UnsupportedOperationException());
    }

/*
    private Element _getTable(Element root, String path) throws SAXException {
	NodeList nodes = _selectNodeList(root, path);
	return ((Element)nodes.item(0));
    }
*/

    private String[] _table2Labels(Element table) {
	Element thead = UHTML.getHTMLElement(table, "thead");
	if (thead == null) {
	    return (null);
	}
	Element tr = UHTML.getHTMLElement(thead, "tr");
	if (tr == null) {
	    return (null);
	}
	Element[] tds = UHTML.getHTMLElements(tr, "th");
	String[] labels = new String[tds.length];
	for (int i = 0;i < tds.length;i++) {
	    labels[i] = UDOM.makeTextDocument(tds[i]);
	}
	return (labels);
    }

    private D2Array _table2Array(Element table) {
	Element tbody = UHTML.getHTMLElement(table, "tbody");
	if (tbody == null) {
	    tbody = table;
	}
	Element[] trs = UHTML.getHTMLElements(tbody, "tr");
	D2Array array = new D2Array();
	for (int y = 0;y < trs.length;y++) {
	    Element[] tds = UHTML.getHTMLElements(trs[y], "td");
	    for (int x = 0;x < tds.length;x++) {
		array.put(x, y, UDOM.makeTextDocument(tds[x]));
	    }
	}
	return (array);
    }

/*
    private NodeList _selectNodeList(Node context, String expr)
	throws SAXException {

	XPathSupport xpathSupport = new XMLParserLiaisonDefault();
	PrefixResolverDefault prefixResolver;
	if (context.getNodeType() == Node.DOCUMENT_NODE) {
	    Document doc = (Document)context;
	    prefixResolver = new PrefixResolverDefault(
		doc.getDocumentElement()
	    );
	} else {
	    prefixResolver = new PrefixResolverDefault(context);
	}
	XPath xpath = new XPath();
	XPathProcessorImpl parser = new XPathProcessorImpl(xpathSupport);
	parser.initXPath(xpath, expr, prefixResolver);
	XObject xobject = xpath.execute(xpathSupport, context, prefixResolver);
	return (xobject.nodeset());
    }
*/
}
