/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.sql.*;
import javax.sql.*;

/**
 * JDBCTabularRepository
 *
 * @since   Aug. 13, 2001
 * @version Aug. 13, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class JDBCTabularRepository extends AbstractTabularRepository {
    private Connection conn_;
    private String tableName_;

    protected JDBCTabularRepository() {
    }

    public JDBCTabularRepository(String url, String tableName)
	throws SQLException {

	_setup(
	    DriverManager.getConnection(url),
	    tableName
	);
    }

    public JDBCTabularRepository(
	String url,
	String tableName,
	String username,
	String password
    ) throws SQLException {
	_setup(
	    DriverManager.getConnection(url, username, password),
	    tableName
	);
    }

    public JDBCTabularRepository(
	Connection connection,
	String tableName
    ) {
	_setup(connection, tableName);
    }

    protected void _setup(
	Connection connection,
	String tableName
    ) {
	conn_ = connection;
	tableName_ = tableName;
    }

    public ITabular getTabular() throws TabularRepositoryException {
	return (_select("SELECT * FROM \"" + tableName_ + "\""));
    }

    public ITabular getTabular(String where)
	throws TabularRepositoryException {

	return (
	    _select("SELECT * FROM \"" + tableName_ + "\" WHERE " + where)
	);
    }

    private ITabular _select(String query) throws TabularRepositoryException {
	try {
	    Statement st = conn_.createStatement();
	    ResultSet rs = st.executeQuery(query);
	    return (new ResultSetTabular(rs));
	} catch (SQLException e) {
	    throw (new TabularRepositoryException(e));
	}
    }

    public void setTabular(ITabular tabular)
	throws TabularRepositoryException {

	try {
	    PreparedStatement st = conn_.prepareStatement(
		_makeUpdateStatement(tabular)
	    );
	    int width = tabular.getWidth();
	    int height = tabular.getHeight();
	    for (int y = 0;y < height;y++) {
		for (int x = 0;x < width;x++) {
		    st.setString(x + 1, tabular.get(x, y).toString());
		}
		st.execute();
	    }
	} catch (SQLException e) {
	    throw (new TabularRepositoryException(e));
	}
    }

    private String _makeUpdateStatement(ITabular tabular) {
	StringBuffer buffer = new StringBuffer();
	buffer.append("UPDATE \"");
	buffer.append(tableName_);
	buffer.append("\" SET ");
	int width = tabular.getWidth();
	if (width > 0) {
	    buffer.append(tabular.getLabel(0));
	    buffer.append(" = ?");
	    for (int i = 1;i < width;i++) {
		buffer.append(", ");
		buffer.append(tabular.getLabel(i));
		buffer.append(" = ?");
	    }
	}
	return (new String(buffer));
    }
}
