/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.util.*;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.relaxer.util.D2Array;

/**
 * ResultSetTabular
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class ResultSetTabular extends AbstractTabular {
    private D2Array contents_ = new D2Array();
    private String[] columnLabels_;

    public ResultSetTabular(ResultSet resultSet) throws SQLException {
	_init(resultSet);
    }

    private void _init(ResultSet resultSet) throws SQLException {
    	ResultSetMetaData metadata = resultSet.getMetaData();
	_buildLabel(metadata);
	_buildData(resultSet, metadata);
    }

    private void _buildLabel(ResultSetMetaData metadata) throws SQLException {
	int width = metadata.getColumnCount();
	columnLabels_ = new String[width];
	for (int i = 0;i < width;i++) {
	    columnLabels_[i] = metadata.getColumnLabel(i + 1);
	}
    }

    private void _buildData(ResultSet resultSet, ResultSetMetaData metadata)
	throws SQLException {

	int width = metadata.getColumnCount();
	int y = 0;
	while (resultSet.next()) {
	    for (int x = 0;x < width;x++) {
		contents_.put(x, y, resultSet.getString(x + 1));
	    }
	    y++;
	}
    }

    public int getWidth() {
	return (contents_.getWidth());
    }

    public int getHeight() {
	return (contents_.getHeight());
    }

    public Object get(int x, int y) {
	return (contents_.get(x, y));
    }

    public String getLabel(int x) {
	return (columnLabels_[x]);
    }
}
