/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.relaxer.xml.sax.DTDSkipper;

/**
 * XHTMLTableTabular
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XHTMLTableTabular extends AbstractHTMLTableTabular {
    public XHTMLTableTabular(String uri) 
	throws ParserConfigurationException, SAXException, IOException {

	Element table = _findTableElement(uri);
	_setup(table);
    }

    private Element _findTableElement(String uri)
	throws ParserConfigurationException, SAXException, IOException {

	DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	DocumentBuilder builder = factory.newDocumentBuilder();
	builder.setEntityResolver(new DTDSkipper());
	Document doc = builder.parse(uri);
	Element table = UHTML.findTableElement(doc.getDocumentElement());
	if (table == null) {
	    throw (new IOException("no table"));
	}
	return (table);
    }
}
