/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.relaxer.xml.UDOM;

/**
 * XMLTabular
 *
 * @since   Jul. 11, 2001
 * @version Apr. 16, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class XMLTabular extends AbstractTabular {
    private Element[] records_;
    private Element[] firstRecord_;

    public XMLTabular(String uri)
	throws ParserConfigurationException, SAXException, IOException {

	DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	DocumentBuilder builder = factory.newDocumentBuilder();
	Document doc = builder.parse(uri);
	_init(doc);
    }

    public XMLTabular(Document doc) {
	_init(doc);
    }

    public XMLTabular(Document[] docs) {
	_init(docs);
    }

    private void _init(Document doc) {
	Element root = doc.getDocumentElement();
	records_ = UDOM.getElements(root);
	if (records_.length > 0) {
	    firstRecord_ = UDOM.getElements(records_[0]);
	}
    }

    private void _init(Document[] docs) {
	records_ = new Element[docs.length];
	for (int i = 0;i < docs.length;i++) {
	      records_[i] = docs[i].getDocumentElement();
	}
	if (records_.length > 0) {
	    firstRecord_ = UDOM.getElements(records_[0]);
	}
    }

    public int getWidth() {
	if (firstRecord_ == null) {
	    return (0);
	}
	return (firstRecord_.length);
    }

    public int getHeight() {
	if (records_ == null) {
	    return (0);
	}
	return (records_.length);
    }

    public String getLabel(int x) {
	if (getHeight() == 0) {
	    return ("");
	}
	return (firstRecord_[x].getTagName());
    }

    public Object get(int x, int y) {
	Element[] fields = UDOM.getElements(records_[y]);
	return (UDOM.getTextValue(fields[x]));
    }
}
