/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.lang.reflect.*;
import java.beans.IntrospectionException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.*;
import org.relaxer.xml.XMLObject;
import org.relaxer.beans.DialogSpaceBean;
import com.AsamiOffice.util.UBean;

/**
 * AbstractDialogTag
 *
 * @since   Jul. 14, 2001
 * @version Apr. 23, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class AbstractDialogTag extends AbstractRelaxerTag {
    private String property_;	// for bean
    private String path_;	// for document

    public final void setProperty(String property) {
	property_ = property;
    }

    public final String getProperty() {
	return (property_);
    }

    public final void setPath(String path) {
	path_ = path;
    }

    public final String getPath() {
	return (path_);
    }

    protected final Object _getValue()
	throws JspTagException, IntrospectionException,
	       InvocationTargetException, IllegalAccessException {

	String property = getProperty();
	String path = getPath();
	if (property != null) {
	    return (
		_getObjectValue(property)
	    );
	} else if (path != null) {
	    return (
		_getDocumentValue(path)
	    );
	} else {
	    return (findDocument());
	}
    }

    private Object _getObjectValue(
	String property
    ) throws JspTagException, IntrospectionException,
	     InvocationTargetException, IllegalAccessException {

	Object object = findRObject();
	return (UBean.getProperty(object, property));
    }

    private String _getDocumentValue(
	String path
    ) throws JspTagException {
//System.out.println("GetValueTag:getDocumentValue:" + path);
	Document doc = findDocument();
	XMLObject xml = new XMLObject(doc);
	return (xml.get(path));
    }
}
