/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.io.IOException;
import java.lang.reflect.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.relaxer.beans.DialogSpaceBean;
import org.relaxer.dialog.IPathResolver;

/**
 * OpenDialogTag
 *
 * @since   Jul. 13, 2001
 * @version Feb. 27, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class OpenDialogTag extends AbstractRelaxerTag {
    public final void setConfig(String uri) throws JspTagException {
	try {
	    DialogSpaceBean bean = new DialogSpaceBean(_resolve(uri));
	    _setupDialogSpace(bean);
	} catch (IOException e) {
	    throw (new JspTagException(e.getMessage()));
	} catch (ClassNotFoundException e) {
	    throw (new JspTagException(e.getMessage()));
	} catch (SAXException e) {
	    throw (new JspTagException(e.getMessage()));
	} catch (ParserConfigurationException e) {
	    throw (new JspTagException(e.getMessage()));
	}
    }

    protected int _doRelaxerStartTag() throws JspException, JspTagException {
	return (super._doRelaxerStartTag());
    }

    protected final void _setupDialogSpace(DialogSpaceBean dialog)
	throws JspTagException, IOException {

	dialog.setPathResolver(
	    new IPathResolver() {
	        public String resolve(String uri) {
		    return (_resolveAll(uri));
		}
	    }
	);
	dialog.open();
	_setJSPAttribute(getDialog(), dialog);
    }
}
