/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.*;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.relaxer.beans.ServletRequestBean;
import org.relaxer.beans.DialogSpaceBean;
import org.relaxer.dialog.IDialogSpace;
import org.relaxer.dialog.IDialogSlot;
import org.relaxer.util.UException;

/**
 * ServletRequestBeanTag
 *
 * @since   Feb.  1, 2001
 * @version May. 22, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class ServletRequestBeanTag extends AbstractRelaxerTag {
    private ServletRequestBean bean_ = new ServletRequestBean();

    public void setClassName(String className) {
	bean_.setClassName(className);
    }

    public void setEncoding(String encoding) throws JspTagException {
	bean_.setEncoding(encoding);
    }

    public int doStartTag() throws JspTagException {
	try {
	    _log(".doStartTag");
	    _setupClassName();
	    ServletRequest req = pageContext.getRequest();
	    bean_.setServletRequest(req);
	    Object rObject = _makeRObject();
	    if (rObject instanceof Document) {
		setDocument((Document)rObject);
	    } else {
		setRObject(rObject);
	    }
	    return (SKIP_BODY);
	} catch (UnsupportedEncodingException e) {
	    throw (new JspTagException(
		"Unsupported encoding = " + bean_.getEncoding()));
	}
    }

    private void _setupClassName() throws JspTagException {
	DialogSpaceBean bean = _getDialogSpaceOut();
	if (bean == null) {
	    return;
	}
	String slotName = getSlot();
	IDialogSpace dialog = bean.getDialogSpace();
	IDialogSlot slot = dialog.getSlot(slotName);
	if (slot == null) {
	    return;
	}
	Class type = slot.getType();
	if (type != null) {
	    setClassName(type.getName());
	}
    }

    private Object _makeRObject() throws JspTagException {
	try {
	    return (bean_.makeRObject());
	} catch (ClassNotFoundException e) {
	    _logMakeObjectFailure(e);
	    throw (_makeMakeObjectFailureException(e));
	} catch (InstantiationException e) {
	    _logMakeObjectFailure(e);
	    throw (_makeMakeObjectFailureException(e));
	} catch (IllegalAccessException e) {
	    _logMakeObjectFailure(e);
	    throw (_makeMakeObjectFailureException(e));
	} catch (NoSuchMethodException e) {
	    _logMakeObjectFailure(e);
	    throw (_makeMakeObjectFailureException(e));
	} catch (InvocationTargetException e) {
	    _logMakeObjectFailure(e);
	    throw (_makeMakeObjectFailureException(e));
	} catch (ParserConfigurationException e) {
	    throw (UException.makeJspTagException(e));
	}
    }

    private JspTagException _makeMakeObjectFailureException(Throwable e) {
	String message = bean_.getClassName()
	    + " would not be generated with the pathlist option";
	return (UException.makeJspTagException(message, e));
    }

    private void _logMakeObjectFailure(Exception e) {
	_log(" ", e);
	_logTagInfo();
    }
}
