/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib.tabular;

import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.relaxer.util.RObjectSlot;
import org.relaxer.xml.UDOM;
import org.relaxer.taglib.AbstractRelaxerTag;
import org.relaxer.tabular.*;
import org.relaxer.beans.HTMLTableBean;
import org.relaxer.util.URelaxer;

/**
 * HTMLTableBeanTag
 *
 * @since   Jul. 11, 2001
 * @version Apr. 23, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class HTMLTableBeanTag extends AbstractRelaxerTag {
    private HTMLTableBean table_ = new HTMLTableBean();

    protected Object _doEvaluate(RObjectSlot[] params)
	throws JspTagException {

	ITabular tabular = null;
	Element thead = null;
	for (int i = 0;i < params.length;i++) {
	    RObjectSlot slot = params[i];
	    Object value = slot.getValue();
	    _log("_doEvaluate - param[" + i + "]:" + value);
	    if (value instanceof ITabular) {
		tabular = (ITabular)value;
	    } else if (value instanceof Document) {
		Document doc = (Document)value;
		Element element = doc.getDocumentElement();
		if ("thead".equals(element.getLocalName())) {
		    thead = element;
		} else if ("http://...".equals(element.getNamespaceURI())) {
		    throw (new UnsupportedOperationException());
		} else {
		    return (new XMLTabular(new Document[] { doc }));
		}
	    } else if (value instanceof Document[]) {
		tabular = new XMLTabular((Document[])value);
	    } else if (value.getClass().isArray()) {
		Document doc = URelaxer.makeRelaxerDocument(value);
System.out.println(org.relaxer.xml.UXMLMaker.getXMLText(doc));
		tabular = new XMLTabular(doc);
	    } else {
		Document doc = URelaxer.makeRelaxerDocument(value);
System.out.println(org.relaxer.xml.UXMLMaker.getXMLText(doc));
		tabular = new XMLTabular(new Document[] { doc });
	    }
	}
	if (tabular != null) {
	    if (tabular instanceof IMutableTabular) {
		IMutableTabular mTabular = (IMutableTabular)tabular;
		if (thead != null) {
		    Element[] trs = UDOM.getElements(thead, "tr");
		    if (trs.length > 0) {
			Element[] ths = UDOM.getElements(trs[0]);
			int index = 0;
			for (int i = 0;i < ths.length;i++) {
			    Element cell = ths[i];
			    String name = cell.getLocalName();
			    if ("th".equals(name) || "td".equals(name)) {
				String label = UDOM.getTextValue(cell);
				mTabular.setLabel(index++, label);
			    }
			}
		    }
		}
	    }
	    table_.setTabular(tabular);
	}
	return (tabular);
    }

    protected int _doRelaxerEndTag() throws JspTagException, JspException {
	try {
	    JspWriter out = pageContext.getOut();
	    out.println(table_.makeHTMLTable());
	} catch (IOException e) {
	    throw (new JspTagException(e.getMessage()));
	}
	return (super._doRelaxerEndTag());
    }

/*
    public int doStartTag() throws JspTagException {
	return (EVAL_BODY_INCLUDE);
    }

    public int doEndTag() throws JspTagException {
	try {
	    JspWriter out = pageContext.getOut();
	    out.println(table_.makeHTMLTable());
	} catch (IOException e) {
	    throw (new JspTagException(e.getMessage()));
	}
	return (EVAL_PAGE);
    }
*/
}
