/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.xml;

import java.util.*;
import java.io.*;
import org.w3c.dom.*;
import org.relaxer.bus.RBusException;
import org.relaxer.xml.UDOM;
import org.relaxer.xml.visitor.*;
import com.AsamiOffice.util.ArrayMap;

/**
 * PathMaker
 *
 * @since   Jul. 15, 2001
 * @version Feb. 25, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class PathMaker extends DOMVisitorBase {
    private Map map_ = new ArrayMap(); // Map<String, String>
    private String pathName_ = "";
    private Stack stack_ = new Stack();

    public Map getPathMap() {
	_dumpMap(map_);
	return (map_);
    }

    private void _dumpMap(Map map) {
	System.out.println(map);
	Set keys = map.keySet();
	Iterator iter = keys.iterator();
	while (iter.hasNext()) {
	    Object key = iter.next();
	    System.out.println(key + ":" + map.get(key));
	}
    }

    public boolean enter(Element element) {
	stack_.push(pathName_);
	pathName_ = pathName_ + "/" + _makeName(element);
	NamedNodeMap attrs = element.getAttributes();
	int size = attrs.getLength();
	for (int i = 0;i < size;i++) {
	    Attr attr = (Attr)attrs.item(i);
	    map_.put(pathName_ + "/@" + attr.getName(), attr.getValue());
	}
	if (!UDOM.hasElement(element)) {
	    map_.put(pathName_, UDOM.getTextValue(element));
	}
	return (true);
    }

    private String _makeName(Element element) {
	String localName = UDOM.getLocalName(element);
	Node parent = element.getParentNode();
	Element[] elements = UDOM.getElements(parent, localName);
	if (elements.length == 0) {
	    throw (new InternalError());
	} else if (elements.length == 1) {
	    return (localName);
	} else {
	    for (int i = 0;i < elements.length;i++) {
		if (elements[i] == element) {
		    return (localName + "[" + (i + 1) + "]");
		}
	    }
	    throw (new InternalError());
	}
    }

    public void leave(Element element) {
	pathName_ = (String)stack_.pop();
    }
}

