# $Id: html_ssi_lua.rb,v 1.2 2001/09/21 17:43:06 mingo Exp $

		#    deafult tag    shortcut for variables
SSI_search_re = /<!--#(.+?)#-->|\[\)(.+?)\(\]/m

SSI_MaxParse = 100

require 'lua'
require 'cscan'

class HTMLSSI

    attr_writer :fget_var,:fget_include,:nparse
    attr_reader :fget_var,:fget_include,:nparse,:li
    
    def initialize()
	@li = Lua.new()
	@li.eval('_html_page="";function print(...) i = 1;while(arg[i]) do _html_page=_html_page..arg[i];i = i+1 end end')
	@li.setFunc('include',self,'get_include')
	@nparse = 0
	@fget_var = nil
	@fget_include = nil
    end

    def get_var(vname)
	#@li.eval('__var='+vname)
	var = @li.get(vname)
	if var then return var end
	if @fget_var then return @fget_var.call(vname) end
	"<!--|#{vname}|-->"
    end
    
    def set_var(vname,vvalue)
	@li.set(vname,vvalue)
    end

    def expr(s)
	@li.eval('_bool_expr='+s)
	@li.get('_bool_expr')
    end    

    private
    
    def get_include(ftype,fname)
	if @fget_include
	    fc = @fget_include.call(ftype,fname)
	else
	    f = File.open(fname)
	    fc = f.read
	    f.close
	end
	parse(fc)
    end
    

    public
    
    def parse(html)
	if @nparse == SSI_MaxParse then raise('Max parse reached') end
	@nparse += 1
	ret_var = ''
	ssc = StringScanner_C.new(html)
	while ssc.rest? do
	    if ssc.scan_until(SSI_search_re)
		ret_var << "\nprint([[#{ssc.pre_match}]])\n"
		if ssc[1]
		    ret_var << ssc[1]
		else
		    ret_var << "\nprint(#{ssc[2]})\n"
		end
	    else
		break
	    end
	end
	ret_var << "\nprint([[#{ssc.rest}]])\n"
	@li.eval(ret_var)
    end
    
    def get_results
	@li.get('_html_page')
    end
end